#ifndef _IMSGBOX_
#define _IMSGBOX_
/*******************************************************************************
* FILE NAME: imsgbox.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMessageBox                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ibitflag.hpp>
#include <iexcept.hpp>
#include <istring.hpp>

class IMessageBoxData;
class IResourceId;
class IWindow;

#pragma pack(4)

class IMessageBox : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMessageBox ( IWindow* owner );

virtual
 ~IMessageBox ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF0(Style, IMessageBox);
static const Style
  IC_IMPORTU okButton,
  IC_IMPORTU okCancelButton,
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU cancelButton,
  IC_IMPORTU enterButton,
  IC_IMPORTU enterCancelButton,
#endif
  IC_IMPORTU retryCancelButton,
  IC_IMPORTU abortRetryIgnoreButton,
  IC_IMPORTU yesNoButton,
  IC_IMPORTU yesNoCancelButton,
  IC_IMPORTU defButton1,
  IC_IMPORTU defButton2,
  IC_IMPORTU defButton3,
  IC_IMPORTU noIcon,
  IC_IMPORTU informationIcon,
  IC_IMPORTU queryIcon,
  IC_IMPORTU warningIcon,
  IC_IMPORTU errorIcon,
  IC_IMPORTU applicationModal,
  IC_IMPORTU systemModal
#ifndef IC_WIN_FLAGNOP
  ,
  IC_IMPORTU moveable
#endif
  ;

/*-------------------------------- Title Text --------------------------------*/
virtual IMessageBox
 &setTitle( const char*        title ),
 &setTitle( const IResourceId& title );

/*------------------------- Showing the Message Box --------------------------*/
enum Response {
#ifndef IC_WIN_FLAGNOP
  enter,
#endif
  ok,
  cancel,
  abort,
  retry,
  ignore,
  yes,
  no,
  unknown
  };

enum Severity {
  information,
  warning,
  action,
  critical,
  catastrophic
  };

virtual IMessageBox::Response
  show ( const char*        message,
         Severity           severity,
         unsigned long      helpId = 0 ),

  show ( const IResourceId& message,
         Severity           severity,
         unsigned long      helpId = 0 ),

  show ( const IResourceId& message,
         const Style&       style,
         unsigned long      helpId = 0 ),

  show ( const char*        message,
         const Style&       style,
         unsigned long      helpId = 0 ),

  show ( const IException&  exception,
         unsigned long      helpId = 0 ),

  show ( const IBaseErrorInfo&  error,
         unsigned long      helpId = 0 );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMessageBox ( const IMessageBox& messageBox );
IMessageBox
 &operator=   ( const IMessageBox& messageBox );

/*--------------------------------- Private ----------------------------------*/
  unsigned long
    showMessageBox  ( const char*   message,
                      const char*   title,
                      unsigned long helpPanelId,
                      const Style&  style );

  static Style
    convertSeverity ( Severity      severity );
static IMessageBox::Response
  convertResponse ( unsigned long buttonId );
IString
  strClTitle;
IWindow
 *pwndClOwner;

IMessageBoxData
 *fMessageBoxData;
}; // IMessageBox

#pragma pack()

#endif  /* _IMSGBOX_  */
