
#ifndef _IMSGTEXT_
#define _IMSGTEXT_
/*******************************************************************************
* FILE NAME: imsgtext.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMsgtext                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#ifdef __IBMCPP__
#pragma info (none)
#pragma pack (4)
#endif





class IMessageText {
public:
/*----------------------------- Constructors ---------------------------------*/
  IMessageText  ( unsigned long messageId,
                  const char*   messageFileName,
                  const char*   textInsert1 = 0,
                  const char*   textInsert2 = 0,
                  const char*   textInsert3 = 0,
                  const char*   textInsert4 = 0,
                  const char*   textInsert5 = 0,
                  const char*   textInsert6 = 0,
                  const char*   textInsert7 = 0,
                  const char*   textInsert8 = 0,
                  const char*   textInsert9 = 0 );

  IMessageText ( const IMessageText& text );

  ~IMessageText ( );

/*-------------------------------- Accessors ---------------------------------*/
  operator const char*  () const;

const char*
  text ( ) const;

IMessageText
 &setDefaultText ( const char*         text ),
 &operator=      ( const IMessageText& text );

private:
/*--------------------------------- Private ----------------------------------*/

char
 *pClText;
int
  bClSuccess;






}; // IMessageText



#ifdef __IBMCPP__
#pragma info (restore)
#pragma pack ()
#endif

#endif // _IMSGTEXT_


