/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMWT_H
#define _IMWT_H

#include <iamwt.h>
#include <iicmwt.h>
#include <iivmwt.h>
#include <iimwt.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <INumber numOfChildren, class Element, class ElementOps>
class IGMultiwayTree;

template <INumber numOfChildren, class Element, class ElementOps>
class IGMultiwayTreeCursor :
  public IElementTreeCursor <Element> {

  typedef  IElementTreeCursor <Element> Inherited;

  typedef  IGMultiwayTree
            <numOfChildren, Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMultiwayTreeCursor
                            (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);

  IGMultiwayTreeCursor <numOfChildren, Element, ElementOps>&
           operator=        (IGMultiwayTreeCursor
                              <numOfChildren,
                               Element, ElementOps> const&);

protected:

           IGMultiwayTreeCursor
                            (ITreeCursorImpl*);

private:


};

template <INumber numOfChildren, class Element, class ElementOps>
class IGMultiwayTree :
  public IAMultiwayTree <numOfChildren, Element> {
protected:

  typedef  IGMultiwayTree <numOfChildren, Element, ElementOps> Self;

  typedef  IMultiwayTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMultiwayTreeImpl
            <PureImplementation> Implementation;
#endif

#define IGMultiwayTreeTypedef(Element, ElementOps)\
  typedef  IMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGMultiwayTreeTypedef (Element, ElementOps);

public:

  typedef  IGMultiwayTreeCursor
            <numOfChildren, Element, ElementOps> Cursor;


           IGMultiwayTree
                            ();

           IGMultiwayTree
                            (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);

  IGMultiwayTree <numOfChildren, Element, ElementOps>&
           operator=        (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);


protected:

           IGMultiwayTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMultiwayTree
                              <numOfChildren,
                               Element, ElementOps> const&);

private:

  friend
  class    IGMultiwayTreeCursor
            <numOfChildren, Element, ElementOps>;



};

template <INumber numOfChildren, class Element>
class IMultiwayTree :
  public IGMultiwayTree
          <numOfChildren, Element, IStdOps <Element> > {

  typedef  IGMultiwayTree
            <numOfChildren, Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IMultiwayTree <numOfChildren, Element> Self;

#define IMultiwayTreeTypedef(Element)\
  typedef  IMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IMultiwayTree
                            ();


protected:

           IMultiwayTree
                              (PureImplementation&);

private:


};

template <INumber numOfChildren, class Element, class ElementOps>
class IVGMultiwayTree :
  public IGMultiwayTree
          <numOfChildren, Element, ElementOps > {

  typedef  IVGMultiwayTree
            <numOfChildren, Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMultiwayTreeImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMultiwayTreeImpl
            <IVMultiwayTreeImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMultiwayTreeTypedef(Element, ElementOps)\
  typedef  IMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGMultiwayTreeTypedef (Element, ElementOps);

public:

           IVGMultiwayTree
                            ();


protected:

           IVGMultiwayTree
                              (PureImplementation&);

private:


};

template <INumber numOfChildren, class Element>
class IVMultiwayTree :
  public IVGMultiwayTree
          <numOfChildren, Element, IStdOps <Element> > {

  typedef  IVGMultiwayTree
            <numOfChildren, Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVMultiwayTree <numOfChildren, Element> Self;

#define IVMultiwayTreeTypedef(Element)\
  typedef  IVMultiwayTreeOps\
            <numOfChildren, Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVMultiwayTree
                            ();


protected:

           IVMultiwayTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imwt.inl>

#pragma info (restore)
#pragma pack ()

#endif
