/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMultiwayTreeCursor
// ---

// public members

template <INumber numOfChildren, class Element, class ElementOps>
inline
IGMultiwayTreeCursor <numOfChildren, Element, ElementOps>::
IGMultiwayTreeCursor
  (IGMultiwayTree
    <numOfChildren, Element, ElementOps> const& collection)
: IElementTreeCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <INumber numOfChildren, class Element, class ElementOps>
inline IGMultiwayTreeCursor <numOfChildren, Element, ElementOps>&
IGMultiwayTreeCursor <numOfChildren, Element, ElementOps>::
operator=
  (IGMultiwayTreeCursor
    <numOfChildren, Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <INumber numOfChildren, class Element, class ElementOps>
inline
IGMultiwayTreeCursor <numOfChildren, Element, ElementOps>::
IGMultiwayTreeCursor (ITreeCursorImpl* impl)
: IElementTreeCursor <Element> (impl)
{
}

// ---
// IGMultiwayTree
// ---

// public members

template <INumber numOfChildren, class Element, class ElementOps>
inline
IGMultiwayTree <numOfChildren, Element, ElementOps>::
IGMultiwayTree ()
{ SetImpl ((Implementation*) *new
                Instantiation ());
}

template <INumber numOfChildren, class Element, class ElementOps>
inline
IGMultiwayTree <numOfChildren, Element, ElementOps>::
IGMultiwayTree
  (IGMultiwayTree
    <numOfChildren, Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <INumber numOfChildren, class Element, class ElementOps>
inline IGMultiwayTree <numOfChildren, Element, ElementOps>&
IGMultiwayTree <numOfChildren, Element, ElementOps>::
operator= (IGMultiwayTree
            <numOfChildren, Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <INumber numOfChildren, class Element, class ElementOps>
inline
IGMultiwayTree <numOfChildren, Element, ElementOps>::
IGMultiwayTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <INumber numOfChildren, class Element, class ElementOps>
inline IGMultiwayTree
 <numOfChildren, Element, ElementOps>::Implementation&
IGMultiwayTree <numOfChildren, Element, ElementOps>::
ImplOf (IGMultiwayTree
         <numOfChildren, Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMultiwayTree
// ---

// public members

template <INumber numOfChildren, class Element>
inline
IMultiwayTree <numOfChildren, Element>::
IMultiwayTree ()
: IGMultiwayTree
   <numOfChildren, Element, IStdOps <Element> > ()
{
}

// protected members

template <INumber numOfChildren, class Element>
inline
IMultiwayTree <numOfChildren, Element>::
IMultiwayTree (PureImplementation& impl)
: IGMultiwayTree
   <numOfChildren, Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGMultiwayTree
// ---

// public members

template <INumber numOfChildren, class Element, class ElementOps>
inline
IVGMultiwayTree <numOfChildren, Element, ElementOps>::
IVGMultiwayTree ()
: IGMultiwayTree
    <numOfChildren, Element, ElementOps> (*(Implementation*) *new
                Instantiation ())
{
}

// protected members

template <INumber numOfChildren, class Element, class ElementOps>
inline
IVGMultiwayTree <numOfChildren, Element, ElementOps>::
IVGMultiwayTree (PureImplementation& impl)
: IGMultiwayTree
    <numOfChildren, Element, ElementOps> (impl)
{
}

// ---
// IVMultiwayTree
// ---

// public members

template <INumber numOfChildren, class Element>
inline
IVMultiwayTree <numOfChildren, Element>::
IVMultiwayTree ()
: IVGMultiwayTree
   <numOfChildren, Element, IStdOps <Element> > ()
{
}

// protected members

template <INumber numOfChildren, class Element>
inline
IVMultiwayTree <numOfChildren, Element>::
IVMultiwayTree (PureImplementation& impl)
: IVGMultiwayTree
   <numOfChildren, Element, IStdOps <Element> > (impl)
{
}
