#ifndef _INOTIFEV_INL_
#define _INOTIFEV_INL_ 0
/*******************************************************************************
* FILE NAME: inotifev.inl                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in inotifev.hpp.                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _INOTIFEV_
  #undef  _INOTIFEV_INL_
  #define _INOTIFEV_INL_ 1
  #include <inotifev.hpp>
#endif

#if _INOTIFEV_INL_
  #define inline
#endif

inline INotificationEvent& INotificationEvent::setEventData( const IEventData& eventData )
{
  this->fEvtData = eventData;
  return *this;
}

inline INotificationEvent& INotificationEvent::setObserverData( const IEventData& observerData)
{
  this->fObsData = observerData;
  return *this;
}

inline INotificationEvent& INotificationEvent::setNotifierAttrChanged(
                                                       Boolean changed)
{
  this->fAttrChanged = changed;
  return *this;
}


inline INotificationId INotificationEvent::notificationId ( ) const
{
  return this->fEvtId;
}

inline INotifier& INotificationEvent::notifier ( ) const
{
  return *(this->fEvtNotifier);
}

inline IEventData INotificationEvent::eventData( ) const
{
  return this->fEvtData;
}

inline IEventData INotificationEvent::observerData( ) const
{
  return this->fObsData;
}

inline IBase::Boolean INotificationEvent::hasNotifierAttrChanged( ) const
{
  return this->fAttrChanged;
}
#endif // _INOTIFEV_INL_
