#ifndef _INOTIFY_
#define _INOTIFY_
/*******************************************************************************
* FILE NAME: inotify.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     INotifier                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ivbase.hpp>

class IObserver;
class IObserverList;
class INotificationEvent;
class IEventData;

#pragma pack(4)

typedef const char
 *INotificationId;

class INotifier : public IVBase {
typedef IVBase
  Inherited;

public:
/*---------------------------- Constructors ----------------------------------*/
  INotifier  ( );
virtual
  ~INotifier ( );

/*----------------------- Notification Members -------------------------------*/
virtual INotifier
 &enableNotification        ( Boolean enable=true ) = 0,
 &disableNotification       ( ) = 0;

virtual Boolean
  isEnabledForNotification  ( ) const = 0;

/*-------------------------- Observer Notification ---------------------------*/
virtual INotifier
 &notifyObservers       ( const INotificationEvent& event ) = 0;

protected:
/*------------------------ Observer Addition and Removal ---------------------*/
virtual INotifier
 &addObserver           ( IObserver&        observer,
                          const IEventData& userData ) = 0,
 &removeObserver        ( IObserver&  observer ) = 0,
 &removeAllObservers    ( ) = 0;

virtual IObserverList
 &observerList          ( ) const = 0;

/*---------------------------- Observer Notification -------------------------*/
virtual INotifier
  &notifyObservers      ( const INotificationId& id ) = 0;

private:
/*--------------------------------- Private ----------------------------------*/
friend class IObserver;
};  //INotifier

#pragma pack()

#endif // _INOTIFY_
