#ifndef _IOBSERVR_
#define _IOBSERVR_
/*******************************************************************************
* FILE NAME: iobservr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IObserver                                                                *
*     IObserverConnectionTo                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ievtdata.hpp>

#pragma pack(4)

class INotificationEvent;
class INotifier;
class IObserverData;

class IObserver : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~IObserver ( );

/*---------------------------- Notifier Attachment ---------------------------*/
virtual IObserver
 &handleNotificationsFor       ( INotifier&        notifier,
                                 const IEventData& userData = IEventData() ),
 &stopHandlingNotificationsFor ( INotifier&        notifier );


protected:
/*----------------------------- Event Dispatching ----------------------------*/
virtual IObserver
 &dispatchNotificationEvent  ( const INotificationEvent& event )=0;

/*------------------------------- Constructors -------------------------------*/
  IObserver ( );

private:
/*--------------------------------- Private ----------------------------------*/
friend class INotifier;
friend class IObserverList;

IObserverData
 *fObserverData;
}; // IObserver

#pragma info(nocpy)

template <class ATarget>
class IObserverConnectionTo : public IObserver {
typedef IObserver
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef void (ATarget::* MemberFunction)( const INotificationEvent& );

/*------------------------------- Constructors -------------------------------*/
  IObserverConnectionTo ( ATarget&       target,
                          MemberFunction memberFunction );
virtual
 ~IObserverConnectionTo ( );

protected:
/*----------------------------- Event Dispatching ----------------------------*/
virtual IObserverConnectionTo<ATarget>
 &dispatchNotificationEvent ( const INotificationEvent& event);

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
MemberFunction
  fConnectedMember;
};  // IObserverConnectionTo

template<class ATarget>
inline
IObserverConnectionTo<ATarget>::IObserverConnectionTo( ATarget& target,
                                                       MemberFunction memberFunction )
: fTarget(target), fConnectedMember(memberFunction)
{
}

#ifndef __TEMPINC__
  #include <iobservr.c>
#endif

#pragma info(restore)

#pragma pack()

#endif /* _IOBSERVR_ */
