#ifndef _IOBSLIST_
#define _IOBSLIST_
/*******************************************************************************
* FILE NAME: iobslist.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IObserverList                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ivbase.hpp>
#include <ireslock.hpp>

class IObserver;
class IObserverDataList;
class INotificationEvent;
class IObserverPtr;
class IObserverListData;

#pragma pack(4)

class IObserverList : public IVBase {
typedef IVBase
  Inherited;

public:

/*---------------------------- Constructors ----------------------------------*/
  IObserverList     ( );

virtual
 ~IObserverList     ( );

class Cursor : public IVBase {
public:
/*---------------------------- Constructors ----------------------------------*/
  Cursor ( IObserverList& observerList );
virtual
 ~Cursor ( );

/*-------------------------- Cursor Movement ---------------------------------*/
virtual Boolean
  setToFirst      ( ),
  setToNext       ( ),
  setToLast       ( ),
  setToPrevious   ( ),
  isValid         ( ) const;

virtual void
  invalidate      ( );

private:
/*--------------------------------- Private ----------------------------------*/
friend class IObserverList;
void
 *fCursor;
}; //Cursor

friend class IObserverList::Cursor;

/*------------------------- Observer Notification ----------------------------*/
IObserverList
 &notifyObservers ( const INotificationEvent& event );

/*---------------------- Observer Addition and Removal -----------------------*/
virtual Boolean
  add             ( IObserver&       observer,
                    void*            userData );
virtual IObserver
 &elementAt       ( const Cursor&    cursor ) const;
virtual IObserverList
 &removeAt        ( const Cursor&    cursor ),
 &remove          ( const IObserver& observer ),
 &removeAll       ( );
unsigned long
 numberOfElements ( ) const;

Boolean
 isEmpty          ( ) const;


private:
/*--------------------------------- Private ----------------------------------*/
IObserverDataList
  *fObserverDataList;
const char
  *observerKey();
const IString
  fObserverKey;
static IString
  obsLockKeyPrefix;

unsigned long
  fNumObservers;
IObserverPtr
  *fpObserverArray;
void removeFromObsArray(const IObserver& observer);
void removeFromObsArray(IObserver& observer);
IObserverListData
  *fObserverListData;
static unsigned long
  myPID();
/*----------------------------- Hidden Functions -----------------------------*/
IObserverList ( const IObserverList& obsList );
IObserverList
   &operator= (const IObserverList& obsList);
}; //IObserverList

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/

#endif /* _IOBSLIST_ */
