#ifndef _IPAGEHDR_
#define _IPAGEHDR_
/*******************************************************************************
* FILE NAME: ipagehdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPageHandler                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ipageevt.hpp>

class IEvent;
class INotebookDrawItemEvent;

#pragma pack(4)

class IPageHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPageHandler  ( );

virtual
  ~IPageHandler ( );

protected:
/*----------------------------- Event Dispatching ----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  help     ( IPageHelpEvent&         event ),
  resize   ( IPageEvent&             event ),
  remove   ( IPageRemoveEvent&       event );

virtual Boolean
  drawTab  ( INotebookDrawItemEvent& event );

virtual Boolean
  selectPending ( IPageSelectEvent&       event ),
  select        ( IPageSelectEvent&       event );
}; // IPageHandler

#pragma pack()

#endif /* _IPAGEHDR_ */
