/*******************************************************************************
* FILE NAME: ipainhdr.c                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the template functions                *
*   declared in ipainhdr.hpp.                                                  * 
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ipainhdr.hpp>


template<class ATarget>
IPaintConnectionTo<ATarget>::IPaintConnectionTo( ATarget&       target,
                                                 MemberFunction memberFunction )
: fTarget(target), fConnectedMember( memberFunction )
{
}

template<class ATarget>
IPaintConnectionTo<ATarget>::~IPaintConnectionTo()
{
}

template<class ATarget>
Boolean
IPaintConnectionTo<ATarget>::paintWindow( IPaintEvent& event )
{
    return ( fTarget.*fConnectedMember ) ( event );
}
