#ifndef _IPAINHDR_
#define _IPAINHDR_
/*******************************************************************************
* FILE NAME: ipainhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPaintHandler                                                            *
*     IPaintConnectionTo                                                       *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <ipainevt.hpp>

#pragma pack(4)

class IPaintHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
virtual
 ~IPaintHandler ( );

protected:
/*------------------------------- Constructors -------------------------------*/
  IPaintHandler ( );

/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  paintWindow ( IPaintEvent& event ) = 0;
}; // IPaintHandler

#pragma info(nocpy)

template <class ATarget>
class IPaintConnectionTo : public IPaintHandler {
typedef IPaintHandler
  Inherited;
public:
/*----------------------------- Type Definitions -----------------------------*/
typedef Boolean  (ATarget::* MemberFunction)( IPaintEvent& );

/*------------------------------- Constructors -------------------------------*/
  IPaintConnectionTo ( ATarget&       target,
                       MemberFunction memberFunction );
virtual
 ~IPaintConnectionTo ( );

protected:
/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  paintWindow ( IPaintEvent& event );

private:
/*--------------------------------- Private ----------------------------------*/
ATarget
 &fTarget;
MemberFunction
  fConnectedMember;
};  // IPaintConnectionTo


#ifndef __TEMPINC__
  #include <ipainhdr.c>
#endif

#pragma info(restore)

#pragma pack()

#endif /* _IPAINHDR_ */
