#ifndef _IPOINT_INL_
#define _IPOINT_INL_ 0
/*******************************************************************************
* FILE NAME: ipoint.inl                                                        *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ipoint.hpp.                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IPOINT_
  #undef  _IPOINT_INL_
  #define _IPOINT_INL_ 1
  #include <ipoint.hpp>
#endif

#if _IPOINT_INL_
  #define inline
#endif

/*---------------------------------- IPair -----------------------------------*/
inline IPair::IPair ( )
  : coordCl1( 0 ), coordCl2( 0 )
  {
  }
inline IPair::IPair ( Coord init )
  : coordCl1( init ), coordCl2( init )
  {
  }
inline IPair::IPair ( Coord coord1, Coord coord2 )
  : coordCl1( coord1 ), coordCl2( coord2 )
  {
  }
inline IPair::Coord  IPair::coord1 ( )  const
  {
  return coordCl1;
  }
inline IPair::Coord  IPair::coord2 ( )  const
  {
  return coordCl2;
  }
inline IPair& IPair::setCoord1 ( Coord coord1 )
  {
  coordCl1 = coord1;
  return *this;
  }
inline IPair& IPair::setCoord2 ( Coord coord2 )
  {
  coordCl2 = coord2;
  return *this;
  }
inline IPair IPair::operator - ( ) const
  {
  return IPair( -coordCl1, -coordCl2 );
  }
inline IBase::Boolean IPair::operator == ( const IPair& pair ) const
  {
  return ( coordCl1 == pair.coordCl1 && coordCl2 == pair.coordCl2);
  }
inline IBase::Boolean IPair::operator != ( const IPair& pair ) const
  {
  return !( *this == pair );
  }
inline IBase::Boolean IPair::operator <  ( const IPair& pair ) const
  {
  return ( coordCl1 < pair.coordCl1 && coordCl2 < pair.coordCl2 );
  }
inline IBase::Boolean IPair::operator >  ( const IPair& pair ) const
  {
  return ( coordCl1 > pair.coordCl1 && coordCl2 > pair.coordCl2 );
  }
inline IBase::Boolean IPair::operator <= (const IPair& pair ) const
  {
  return ( coordCl1 <= pair.coordCl1 && coordCl2 <= pair.coordCl2);
  }
inline IBase::Boolean IPair::operator >= ( const IPair& pair ) const
  {
  return ( coordCl1 >= pair.coordCl1 && coordCl2 >= pair.coordCl2);
  }
inline IPair operator +  ( const IPair& pair1, const IPair& pair2 )
  {
  return IPair( pair1.coordCl1 + pair2.coordCl1,
                pair1.coordCl2 + pair2.coordCl2 );
  }
inline IPair operator *  ( const IPair& pair1, const IPair& pair2 )
  {
  return IPair( pair1.coordCl1 * pair2.coordCl1,
                pair1.coordCl2 * pair2.coordCl2 );
  }
inline IPair operator *  ( const IPair& pair1, double d )
  {
  return IPair( (IPair::Coord)(d * pair1.coordCl1),
                (IPair::Coord)(d * pair1.coordCl2));
  }
inline IPair operator -  ( const IPair& pair1, const IPair& pair2 )
  {
  return IPair( pair1.coordCl1 - pair2.coordCl1,
                pair1.coordCl2 - pair2.coordCl2);
  }
inline IPair operator / ( const IPair& pair1, const IPair& pair2 )
  {
  return IPair( pair1.coordCl1 / pair2.coordCl1,
                pair1.coordCl2 / pair2.coordCl2);
  }
inline IPair operator /  ( const IPair& pair1, double d )
  {
  return IPair( (IPair::Coord)(pair1.coordCl1 / d),
                (IPair::Coord)(pair1.coordCl2 / d) );
  }
inline IPair operator %  ( const IPair& pair1, const IPair& pair2 )
  {
  return IPair( pair1.coordCl1 % pair2.coordCl1,
                pair1.coordCl2 % pair2.coordCl2 );
  }
inline IPair operator %  ( const IPair& pair1, IPair::Coord d )
  {
  return IPair( pair1.coordCl1 % d,
                pair1.coordCl2 % d );
  }
inline IPair& IPair::operator += ( const IPair &aPair )
  {
  return (*this).setCoord1( coordCl1 + aPair.coordCl1 ).
                 setCoord2( coordCl2 + aPair.coordCl2 );
  }
inline IPair& IPair::operator -= ( const IPair &aPair )
  {
  return (*this).setCoord1( coordCl1 - aPair.coordCl1 ).
                 setCoord2( coordCl2 - aPair.coordCl2 );
  }
inline IPair& IPair::operator *= ( const IPair &aPair )
  {
  return (*this).setCoord1( coordCl1 * aPair.coordCl1 ).
                 setCoord2( coordCl2 * aPair.coordCl2 );
  }
inline IPair& IPair::operator *= ( double d )
  {
  return (*this).setCoord1( (Coord)(coordCl1 * d) ).
                 setCoord2( (Coord)(coordCl2 * d) );
  }
inline IPair& IPair::operator /= ( const IPair &aPair )
  {
  return (*this).setCoord1( coordCl1 / aPair.coordCl1 ).
                 setCoord2( coordCl2 / aPair.coordCl2 );
  }
inline IPair& IPair::operator /= ( double d )
  {
  return (*this).setCoord1( (Coord)(coordCl1 / d) ).
                 setCoord2( (Coord)(coordCl2 / d) );
  }
inline IPair& IPair::operator %= ( const IPair &aPair )
  {
  return (*this).setCoord1( coordCl1 % aPair.coordCl1 ).
                 setCoord2( coordCl2 % aPair.coordCl2 );
  }
inline IPair& IPair::operator %= ( Coord d )
  {
  return (*this).setCoord1( coordCl1 % d ).
                 setCoord2( coordCl2 % d );
  }
inline long IPair::dotProduct( const IPair &aPair ) const
  {
  return coordCl1 * aPair.coordCl1 + coordCl2 * aPair.coordCl2;
  }
inline IPair transpose ( const IPair &aPair )
  {
  return IPair( aPair.coordCl2, aPair.coordCl1 );
  }
inline IPair& IPair::transpose ( )
  {
  *this = ::transpose( *this );
  return *this;
  }
inline IPair& IPair :: scaleBy ( double xfact, double yfact )
  {
  setCoord1( (Coord)(coordCl1 * xfact) ).setCoord2( (Coord)(coordCl2 * yfact) );
  return *this;
  }
inline IPair IPair :: scaledBy ( double xfact, double yfact ) const
  {
  IPair result( *this );
  return result.scaleBy( xfact, yfact );
  }
/*---------------------------------- IPoint ----------------------------------*/
inline IPoint::IPoint ( )
  {
  }
inline IPoint::IPoint ( const IPair& pair )
  : IPair( pair )
  {
  }
inline IPoint::IPoint ( Coord x, Coord y )
  : IPair( x, y )
  {
  }
#if (defined(OS2DEF_INCLUDED) || defined(_WINDEF_))
inline IPoint::IPoint ( const POINTL& ptl )
  : IPair( ptl.x, ptl.y )
  {
  }
#endif
#ifdef _WINDEF_
inline IPoint::IPoint ( const POINT& ptl )
  : IPair( ptl.x, ptl.y )
  {
  }
#endif
inline IPair::Coord IPoint::x ( ) const
  {
  return coord1();
  }
inline IPair::Coord IPoint::y ( ) const
  {
  return coord2();
  }
inline IPoint& IPoint::setX ( Coord x )
  {
  setCoord1( x );
  return *this;
  }
inline IPoint& IPoint::setY ( Coord y )
  {
  setCoord2( y );
  return *this;
  }

/*---------------------------------- ISize -----------------------------------*/
inline ISize::ISize ( )
  {
  }
inline ISize::ISize ( const IPair& pair )
  : IPair( pair )
  {
  }
inline ISize::ISize ( Coord width, Coord height )
  : IPair( width, height )
  {
  }
#if (defined(GPI_INCLUDED) || defined(_WINDEF_))
inline ISize::ISize ( const SIZEL &sizl )
  : IPair( sizl.cx, sizl.cy )
  {
  }
#endif
#ifdef OS2DEF_INCLUDED
inline ISize::ISize ( const RECTL& rcl )
  : IPair ( rcl.xRight - rcl.xLeft, rcl.yTop - rcl.yBottom )
  {
  }
#endif
#ifdef _WINDEF_
inline ISize::ISize ( const RECTL& rcl )
  : IPair ( rcl.right - rcl.left, rcl.bottom - rcl.top )
  {
  }
#endif
inline IPair::Coord ISize::width ( ) const
  {
  return  coord1();
  }
inline IPair::Coord ISize::height ( ) const
  {
  return  coord2();
  }
inline ISize& ISize::setWidth ( Coord cx )
  {
  setCoord1( cx );
  return *this;
  }
inline ISize& ISize::setHeight ( Coord cy )
  {
  setCoord2( cy );
  return *this;
  }

/*---------------------------------- IRange ----------------------------------*/
inline IRange::IRange ( )
  : IPair( 0, 0 )
  {
  }
inline IRange::IRange ( const IPair& pair )
  : IPair( pair )
  {
  }
inline IRange::IRange ( Coord lowerBound, Coord upperBound )
  : IPair( lowerBound, upperBound )
  {
  }
inline IPair::Coord IRange::lowerBound ( ) const
  {
  return coord1();
  }
inline IPair::Coord IRange::upperBound ( ) const
  {
  return coord2();
  }
inline IRange& IRange::setLowerBound ( Coord lowerBound )
  {
  setCoord1( lowerBound );
  return *this;
  }
inline IRange& IRange::setUpperBound ( Coord upperBound )
  {
  setCoord2( upperBound );
  return *this;
  }
inline IBase::Boolean IRange::includes ( Coord aValue ) const
  {
  return ( aValue >= lowerBound() && aValue <= upperBound() );
  }
#endif /* _IPOINT_INL_ */
