#ifndef _IPOPMENU_
#define _IPOPMENU_
/*******************************************************************************
* FILE NAME: ipopmenu.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class:                                                  *
*     IPopUpMenu                                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <imenu.hpp>

class IPoint;
class IResourceId;
class IWindow;
class IPopUpMenuData;

#pragma pack(4)

class IPopUpMenu : public IMenu {
typedef IMenu
 Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IPopUpMenu ( IWindow*           owner,
               unsigned long      menuWindowId,
               const Style&       style = defaultStyle());

  IPopUpMenu ( const IResourceId& menuResId,
               IWindow*           owner );
virtual
 ~IPopUpMenu ( );

/*-------------------------------- Visibility --------------------------------*/
virtual IPopUpMenu
 &show ( const IPoint& atLocation );


protected:
/*---------------------- Event-Handling Implementation -----------------------*/

private:
/*------------------------------ Hidden Members ------------------------------*/
  IPopUpMenu ( const IPopUpMenu& menu );
IPopUpMenu
 &operator=  ( const IPopUpMenu& menu );
IPopUpMenu
 &show       ( Boolean           showMenu = true );

/*--------------------------------- Private ----------------------------------*/
IPopUpMenuData
 *fPopUpMenuData;
}; // IPopUpMenu

#pragma pack()

  #include <ipopmenu.inl>

#endif  /* _IPOPMENU_ */
