/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGPriorityQueueAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsListCursor <Element, Key, ElementOps>::
IGPriorityQueueAsListCursor
  (IGPriorityQueueAsList
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsListCursor <Element, Key, ElementOps>&
IGPriorityQueueAsListCursor <Element, Key, ElementOps>::
operator=
  (IGPriorityQueueAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsListCursor <Element, Key, ElementOps>::
IGPriorityQueueAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGPriorityQueueAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsList <Element, Key, ElementOps>::
IGPriorityQueueAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsList <Element, Key, ElementOps>::
IGPriorityQueueAsList
  (IGPriorityQueueAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsList <Element, Key, ElementOps>&
IGPriorityQueueAsList <Element, Key, ElementOps>::
operator= (IGPriorityQueueAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGPriorityQueueAsList <Element, Key, ElementOps>::
IGPriorityQueueAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGPriorityQueueAsList
 <Element, Key, ElementOps>::Implementation&
IGPriorityQueueAsList <Element, Key, ElementOps>::
ImplOf (IGPriorityQueueAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IPriorityQueueAsList
// ---

// public members

template <class Element, class Key>
inline
IPriorityQueueAsList <Element, Key>::
IPriorityQueueAsList (INumber numberOfElements)
: IGPriorityQueueAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IPriorityQueueAsList <Element, Key>::
IPriorityQueueAsList (PureImplementation& impl)
: IGPriorityQueueAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGPriorityQueueAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueueAsList <Element, Key, ElementOps>::
IVGPriorityQueueAsList (INumber numberOfElements)
: IGPriorityQueueAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGPriorityQueueAsList <Element, Key, ElementOps>::
IVGPriorityQueueAsList (PureImplementation& impl)
: IGPriorityQueueAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVPriorityQueueAsList
// ---

// public members

template <class Element, class Key>
inline
IVPriorityQueueAsList <Element, Key>::
IVPriorityQueueAsList (INumber numberOfElements)
: IVGPriorityQueueAsList
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVPriorityQueueAsList <Element, Key>::
IVPriorityQueueAsList (PureImplementation& impl)
: IVGPriorityQueueAsList
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
