#ifndef _IPROCADR_
#define _IPROCADR_
/*******************************************************************************
* FILE NAME: iprocadr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IProcedureAddress                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>
#include <ireslib.hpp>

class IProcedureAddressData;

#pragma pack(4)


template < class PtrToFnType >
class IProcedureAddress : public IBase {
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IProcedureAddress ( const char*          entryPoint,
                      const char*          dllName )
    : dll           ( new IDynamicLinkLibrary( dllName ) ),
      isOrdinal     ( false ),
      name          ( entryPoint ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( entryPoint ) );
  }

  IProcedureAddress ( const char*          entryPoint,
                      IDynamicLinkLibrary& aDLL )
    : dll           ( new IDynamicLinkLibrary( aDLL ) ),
      isOrdinal     ( false ),
      name          ( entryPoint ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( entryPoint ) );
  }

  IProcedureAddress ( unsigned long        ordinal,
                      const char*          dllName )
    : dll           ( new IDynamicLinkLibrary( dllName ) ),
      isOrdinal     ( true ),
      ord           ( ordinal ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( ordinal ) );
  }

  IProcedureAddress ( unsigned long        ordinal,
                      IDynamicLinkLibrary& aDLL )
    : dll           ( new IDynamicLinkLibrary( aDLL ) ),
      isOrdinal     ( true ),
      ord           ( ordinal ),
      pProcAddrData ( 0 )
  {
    fnPtr = PtrToFnType( this->dll->procAddress( ordinal ) );
  }

  ~IProcedureAddress ( )
  {
    delete dll;
  }

/*--------------------------- Pointers to Functions --------------------------*/
  operator PtrToFnType ( ) const
  {
    return fnPtr;
  }

/*------------------------------- Memory Model -------------------------------*/
Boolean
  is32Bit ( ) const
  {
    if ( isOrdinal )
      return dll->isEntryPoint32Bit( ord );
    else
      return dll->isEntryPoint32Bit( name );
  }

private:
/*-------------------------------- Private -----------------------------------*/
PtrToFnType
 fnPtr;

IDynamicLinkLibrary
 *dll;

Boolean
 isOrdinal;

union {
  unsigned long
    ord;
  const char
   *name;
};

IProcedureAddressData
 *pProcAddrData;

}; // IProcedureAddress


#pragma pack()

#endif // _IPROCADR_
