#ifndef _IPROFILE_
#define _IPROFILE_
/*******************************************************************************
* FILE NAME: iprofile.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     iProfile                                                                 *
*     iProfile::Cursor                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ihandle.hpp>
#include <istring.hpp>

class IProfileData;
class IProfileCursorData;

#pragma pack(4)

class IProfile : public IVBase {
typedef IVBase
  Inherited;
public:
class Cursor;
/*------------------------------- Constructors -------------------------------*/
  IProfile  ( const char*      profileName );
  IProfile  ( const IProfile&  aProfile );

virtual
 ~IProfile  ( );

IProfile
 &operator= ( const IProfile&  aProfile );

/*----------------------------- Special Profiles -----------------------------*/
static IProfile
  systemProfile ( );

static IProfile
  userProfile   ( );

/*---------------------------- Profile Information ---------------------------*/
virtual IString
  name                 ( ) const,
  applicationOrKeyAt   ( const Cursor& cursor ) const;


virtual unsigned long
  numberOfKeys         ( const char*   applName = 0 ) const;

virtual unsigned long
  numberOfApplications ( ) const;


/*------------------------ Default Application Name --------------------------*/
virtual IString
  defaultApplicationName    ( ) const;

virtual IProfile
 &setDefaultApplicationName ( const char* applName );

/*------------------------ Reading and Writing Data --------------------------*/
virtual IString
  elementWithKey               ( const char* key,
                                 const char* applName = 0 ) const;

virtual long
  integerWithKey               ( const char* key,
                                 const char* applName = 0 ) const;

virtual IProfile
 &addOrReplaceElementWithKey   ( const char* key,
                                 const IString& data,
                                 const char* applName = 0 ),

 &addOrReplaceElementWithKey   ( const char* key,
                                 long        data,
                                 const char* applName = 0 );

virtual IProfile
 &deleteElementWithKey         ( const char* key,
                                 const char* applName = 0 ),

 &deleteElementWithApplication ( const char* applName = 0 );

static void
  deleteProfile                ( const char* profileName ),
  enableKeyMapping             ( Boolean     mapKey = true ),
  disableKeyMapping            ( );

static Boolean
  isKeyMappingEnabled          ( );

/*--------------------------------- Testing ----------------------------------*/
virtual Boolean
  containsApplication ( const char* applName ) const,
  containsKeyName     ( const char* key,
                        const char* applName = 0 ) const;

class Cursor : public IVBase {
public:
/*------------------------------- Constructors -------------------------------*/
  Cursor ( IProfile&   profile );
  Cursor ( IProfile&   profile,
           const char* applName );
virtual
 ~Cursor ( );

/*---------------------------- Profile Iteration -----------------------------*/
virtual Boolean
  setToFirst    ( ),
  setToNext     ( ),
  setToPrevious ( ),
  setToLast     ( ),
  isValid       ( Boolean checkFile = false ) const;

virtual void
  invalidate    ( );

private:
/*-------------------------------- Private -----------------------------------*/
friend class IProfile;


void
  initCursor ( const char*   profileName,
               const char*   appName );

unsigned
  pos;

IString
  strCl,
  applNameCl;


IProfileCursorData
 *fCursorData;

}; // IProfile::Cursor


private:
/*------------------------------ Hidden Members ------------------------------*/

/*--------------------------------- Private ----------------------------------*/
friend class IProfileData;


IString
  defApplName,
  profileName;


IProfileData
 *fProfileData;
}; // iProfile

#pragma pack()

#endif // _IPROFILE_
