#ifndef _IPTARRAY_
#define _IPTARRAY_
/*******************************************************************************
* FILE NAME: iptarray.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IPointArray                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ibase.hpp>

class IPoint;

#pragma pack(4)


class IPointArray : public IBase {
typedef IBase
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IPointArray ( unsigned long dimension = 0,
                const IPoint* array = 0       );

  IPointArray ( const IPointArray& pointArray );

IPointArray
  &operator=  ( const IPointArray& pointArray );

  ~IPointArray ( );


/*--------------------------------- Data Access ------------------------------*/
unsigned long
  size             ( ) const;

IPointArray
  &resize          ( unsigned long newsize ),
  &reverse         ( ),
   reversed        ( ) const,
  &insert          ( unsigned long index,
                     const IPoint& point   ),
  &add             ( const IPoint& point   ),
  &remove          ( unsigned long index   );

IPoint
  &operator []     ( unsigned long index   );
const IPoint
  &operator []     ( unsigned long index   ) const;

/*----------------------------- Comparisons ----------------------------------*/
Boolean
  operator== (const IPointArray& pointArray) const;
  operator!= (const IPointArray& pointArray) const;


private:
/*-------------------------------- Private -----------------------------------*/
IPoint
 *fPtArray;
unsigned long
  fDim;

}; // IPointArray


#pragma pack()

#endif // _IPTARRAY_
