/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IPTR_H
#define _IPTR_H

#include <iglobals.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

enum IExplicitInit { IINIT };

template <class Element>
class IElemPointer {
public:

           IElemPointer     ();

           IElemPointer     (Element*, IExplicitInit = IINIT);

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element*
                            () const;

  friend 
  Element& elementForOps    (IElemPointer <Element>&);

  friend
  Element const&
           elementForOps    (IElemPointer <Element> const&) ;

protected:

private:

  Element* ivPtr;


};


template <class Element>
class IMngPointer {
public:

           IMngPointer      ();

           IMngPointer      (Element*, IExplicitInit);

           IMngPointer      (IMngPointer <Element> const&);

          ~IMngPointer      ();

  IMngPointer <Element>&
           operator=        (IMngPointer <Element> const&);

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element* () const;


private:

  struct PtrRc
  { Element *ivPtr;

    unsigned int ivRc;

             PtrRc (Element *ptr)
             : ivPtr (ptr), ivRc (1)
             {
             }

            ~PtrRc ()
             { delete ivPtr; }

  } *ivPtrRc;


};


template <class Element>
class IMngElemPointer : protected IMngPointer <Element> {
public:

           IMngElemPointer  () ;

           IMngElemPointer  (Element*, IExplicitInit);

#if defined (ICLCC_COMPAT_PTR)
           IMngElemPointer  (Element const&);

           IMngElemPointer  (Element*);
#endif

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element*
                            () const;

  friend
  Element& elementForOps    (IMngElemPointer <Element>&);

  friend
  Element const&
           elementForOps    (IMngElemPointer <Element> const&);


protected:

private:


};



template <class Element>
class IAutoPointer {
public:

           IAutoPointer     ();

           IAutoPointer     (Element*, IExplicitInit);

           IAutoPointer     (IAutoPointer <Element> const&);

          ~IAutoPointer     ();

  void     operator=        (IAutoPointer <Element> const&);

           operator Element*
                            () const;

  Element& operator*        () const;

  Element* operator->       () const;

protected:

private:

  Element* ivPtr;


};


template <class Element>
class IAutoElemPointer : protected IAutoPointer <Element> {
public:

           IAutoElemPointer ();

           IAutoElemPointer (Element*, IExplicitInit);

  Element& operator*        () const;

  Element* operator->       () const;

           operator Element*
                            () const;

  friend
  Element& elementForOps    (IAutoElemPointer <Element>&);

  friend
  Element const&
           elementForOps    (IAutoElemPointer <Element> const&);

protected:

private:


};



#include <iptr.inl>


#pragma info (restore)
#pragma pack ()

#endif
