/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IQUDIL_H
#define _IQUDIL_H

#include <iaqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGQueueAsDilTable;

template <class Element, class ElementOps>
class IGQueueAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGQueueAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueAsDilTableCursor
                            (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsDilTableCursor <Element, ElementOps>&
           operator=        (IGQueueAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGQueueAsDilTable :
  public IAQueue <Element> {
protected:

  typedef  IGQueueAsDilTable <Element, ElementOps> Self;

  typedef  ISequenceAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGQueueAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGQueueAsDilTable
                            (INumber = 100);

           IGQueueAsDilTable
                            (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsDilTable <Element, ElementOps>&
           operator=        (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGQueueAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueueAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IQueueAsDilTable :
  public IGQueueAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IGQueueAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IQueueAsDilTable <Element> Self;

#define IQueueAsDilTableTypedef(Element)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IQueueAsDilTable
                            (INumber = 100);


protected:

           IQueueAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGQueueAsDilTable :
  public IGQueueAsDilTable
          <Element, ElementOps > {

  typedef  IVGQueueAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueAsDilTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueAsDilTableTypedef (Element, ElementOps);

public:

           IVGQueueAsDilTable
                            (INumber = 100);


protected:

           IVGQueueAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVQueueAsDilTable :
  public IVGQueueAsDilTable
          <Element, IStdOps <Element> > {

  typedef  IVGQueueAsDilTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVQueueAsDilTable <Element> Self;

#define IVQueueAsDilTableTypedef(Element)\
  typedef  IVSequenceAsDilTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVQueueAsDilTable
                            (INumber = 100);


protected:

           IVQueueAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iqudil.inl>

#pragma info (restore)
#pragma pack ()

#endif
