/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGQueueAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueueAsDilTableCursor <Element, ElementOps>::
IGQueueAsDilTableCursor
  (IGQueueAsDilTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGQueueAsDilTableCursor <Element, ElementOps>&
IGQueueAsDilTableCursor <Element, ElementOps>::
operator=
  (IGQueueAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueueAsDilTableCursor <Element, ElementOps>::
IGQueueAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGQueueAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueueAsDilTable <Element, ElementOps>::
IGQueueAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGQueueAsDilTable <Element, ElementOps>::
IGQueueAsDilTable
  (IGQueueAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGQueueAsDilTable <Element, ElementOps>&
IGQueueAsDilTable <Element, ElementOps>::
operator= (IGQueueAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueueAsDilTable <Element, ElementOps>::
IGQueueAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGQueueAsDilTable
 <Element, ElementOps>::Implementation&
IGQueueAsDilTable <Element, ElementOps>::
ImplOf (IGQueueAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IQueueAsDilTable
// ---

// public members

template <class Element>
inline
IQueueAsDilTable <Element>::
IQueueAsDilTable (INumber numberOfElements)
: IGQueueAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IQueueAsDilTable <Element>::
IQueueAsDilTable (PureImplementation& impl)
: IGQueueAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGQueueAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGQueueAsDilTable <Element, ElementOps>::
IVGQueueAsDilTable (INumber numberOfElements)
: IGQueueAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGQueueAsDilTable <Element, ElementOps>::
IVGQueueAsDilTable (PureImplementation& impl)
: IGQueueAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVQueueAsDilTable
// ---

// public members

template <class Element>
inline
IVQueueAsDilTable <Element>::
IVQueueAsDilTable (INumber numberOfElements)
: IVGQueueAsDilTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVQueueAsDilTable <Element>::
IVQueueAsDilTable (PureImplementation& impl)
: IVGQueueAsDilTable
   <Element, IStdOps <Element> > (impl)
{
}
