/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IQULST_H
#define _IQULST_H

#include <iaqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqlst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGQueueAsList;

template <class Element, class ElementOps>
class IGQueueAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGQueueAsList
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueAsListCursor
                            (IGQueueAsList
                              <
                               Element, ElementOps> const&);

  IGQueueAsListCursor <Element, ElementOps>&
           operator=        (IGQueueAsListCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGQueueAsList :
  public IAQueue <Element> {
protected:

  typedef  IGQueueAsList <Element, ElementOps> Self;

  typedef  ISequenceAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueAsListTypedef (Element, ElementOps);

public:

  typedef  IGQueueAsListCursor
            <Element, ElementOps> Cursor;


           IGQueueAsList
                            (INumber = 100);

           IGQueueAsList
                            (IGQueueAsList
                              <
                               Element, ElementOps> const&);

  IGQueueAsList <Element, ElementOps>&
           operator=        (IGQueueAsList
                              <
                               Element, ElementOps> const&);


protected:

           IGQueueAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueueAsList
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueAsListCursor
            <Element, ElementOps>;



};

template <class Element>
class IQueueAsList :
  public IGQueueAsList
          <Element, IStdOps <Element> > {

  typedef  IGQueueAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IQueueAsList <Element> Self;

#define IQueueAsListTypedef(Element)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IQueueAsList
                            (INumber = 100);


protected:

           IQueueAsList
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGQueueAsList :
  public IGQueueAsList
          <Element, ElementOps > {

  typedef  IVGQueueAsList
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueAsListTypedef(Element, ElementOps)\
  typedef  ISequenceAsListOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueAsListTypedef (Element, ElementOps);

public:

           IVGQueueAsList
                            (INumber = 100);


protected:

           IVGQueueAsList
                              (PureImplementation&);

private:


};

template <class Element>
class IVQueueAsList :
  public IVGQueueAsList
          <Element, IStdOps <Element> > {

  typedef  IVGQueueAsList
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVQueueAsList <Element> Self;

#define IVQueueAsListTypedef(Element)\
  typedef  IVSequenceAsListOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVQueueAsList
                            (INumber = 100);


protected:

           IVQueueAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iqulst.inl>

#pragma info (restore)
#pragma pack ()

#endif
