/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGQueueAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueueAsListCursor <Element, ElementOps>::
IGQueueAsListCursor
  (IGQueueAsList
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGQueueAsListCursor <Element, ElementOps>&
IGQueueAsListCursor <Element, ElementOps>::
operator=
  (IGQueueAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueueAsListCursor <Element, ElementOps>::
IGQueueAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGQueueAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGQueueAsList <Element, ElementOps>::
IGQueueAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGQueueAsList <Element, ElementOps>::
IGQueueAsList
  (IGQueueAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGQueueAsList <Element, ElementOps>&
IGQueueAsList <Element, ElementOps>::
operator= (IGQueueAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGQueueAsList <Element, ElementOps>::
IGQueueAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGQueueAsList
 <Element, ElementOps>::Implementation&
IGQueueAsList <Element, ElementOps>::
ImplOf (IGQueueAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IQueueAsList
// ---

// public members

template <class Element>
inline
IQueueAsList <Element>::
IQueueAsList (INumber numberOfElements)
: IGQueueAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IQueueAsList <Element>::
IQueueAsList (PureImplementation& impl)
: IGQueueAsList
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGQueueAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGQueueAsList <Element, ElementOps>::
IVGQueueAsList (INumber numberOfElements)
: IGQueueAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGQueueAsList <Element, ElementOps>::
IVGQueueAsList (PureImplementation& impl)
: IGQueueAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVQueueAsList
// ---

// public members

template <class Element>
inline
IVQueueAsList <Element>::
IVQueueAsList (INumber numberOfElements)
: IVGQueueAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVQueueAsList <Element>::
IVQueueAsList (PureImplementation& impl)
: IVGQueueAsList
   <Element, IStdOps <Element> > (impl)
{
}
