/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IQUTAB_H
#define _IQUTAB_H

#include <iaqu.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGQueueAsTable;

template <class Element, class ElementOps>
class IGQueueAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGQueueAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGQueueAsTableCursor
                            (IGQueueAsTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsTableCursor <Element, ElementOps>&
           operator=        (IGQueueAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGQueueAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGQueueAsTable :
  public IAQueue <Element> {
protected:

  typedef  IGQueueAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGQueueAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGQueueAsTableTypedef (Element, ElementOps);

public:

  typedef  IGQueueAsTableCursor
            <Element, ElementOps> Cursor;


           IGQueueAsTable
                            (INumber = 100);

           IGQueueAsTable
                            (IGQueueAsTable
                              <
                               Element, ElementOps> const&);

  IGQueueAsTable <Element, ElementOps>&
           operator=        (IGQueueAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGQueueAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGQueueAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGQueueAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class IQueueAsTable :
  public IGQueueAsTable
          <Element, IStdOps <Element> > {

  typedef  IGQueueAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IQueueAsTable <Element> Self;

#define IQueueAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IQueueAsTable
                            (INumber = 100);


protected:

           IQueueAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGQueueAsTable :
  public IGQueueAsTable
          <Element, ElementOps > {

  typedef  IVGQueueAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGQueueAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGQueueAsTableTypedef (Element, ElementOps);

public:

           IVGQueueAsTable
                            (INumber = 100);


protected:

           IVGQueueAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVQueueAsTable :
  public IVGQueueAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGQueueAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVQueueAsTable <Element> Self;

#define IVQueueAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVQueueAsTable
                            (INumber = 100);


protected:

           IVQueueAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iqutab.inl>

#pragma info (restore)
#pragma pack ()

#endif
