#ifndef _IRECOHDR_
  #define _IRECOHDR_
/*******************************************************************************
* FILE NAME: irecohdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IRecoordHandler                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>

class IEvent;
class IRectangle;
class IWindow;
class IWindowHandle;
class IRecoordHandlerData;

#pragma pack(4)

class IRecoordHandler : public IHandler {
typedef IHandler
  Inherited;
/*******************************************************************************
* The IRecoordHandler class handles the notification that a window or control  *
* is being resized.                                                            *
*                                                                              *
* A recoordination event notifies a window when the size and position of the   *
* window's client area must be calculated.  This event is processed by this    *
* handler to make any adjustments in child window coordinates which are        *
* necessary due to the window size change.   This handler is distinct from     *
* an IResizeHander in that it runs before the IResizeHander and processes      *
* a different message.   The message handled by the IRecoordHandler is         *
* WM_CALCVALIDRECTS/WM_NCCALCSIZE.                                             *
* IRecoordHandler processes the resizing event by creating an IRecoordEvent    *
* object and routing it to the virtual windowResize function.  This virtual    *
* function allows you to supply your own specialized processing of the event.  *
* The return value from the virtual function specifies whether the             *
* IResizeEvent should be passed on for additional processing, as follows:      *
*                                                                              *
*   Value   Meaning                                                            *
*   ---------------                                                            *
*   true  - The IResizeEvent object has been handled and requires no           *
*           additional processing.                                             *
*   false - The IResizeEvent object should be passed to the next handler.  If  *
*           the next handler is the last handler for the window or control,    *
*           the event is passed on a call to the window or control's           *
*           defaultProcedure function (see IWindow::defaultProcedure).         *
*                                                                              *
*******************************************************************************/
public:
/*-------------------------- Constructors/Destructor ---------------------------
| The only way to create objects of this class is by using the default         |
| constructor.                                                                 |
------------------------------------------------------------------------------*/
  IRecoordHandler ( );
virtual
 ~IRecoordHandler ( );

/*------------------------------ Default Object --------------------------------
|  defaultHandler - returns a pointer to the default object of this class      |
------------------------------------------------------------------------------*/
static IRecoordHandler
  *defaultHandler( );

protected:
/*---------------------------- Event Dispatching -------------------------------
| This function evaluates the event to determine if it is appropriate for      |
| this handler object to process.  If it is, this function calls the virtual   |
| function used to process the event.                                          |
|   dispatchHandlerEvent - Calls the windowResize function if a resize event   |
|                          is found.                                           |
------------------------------------------------------------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -------------------------------
| Event processing functions are called when an event affecting recoordination |
| occurs.                                                                      |
|   windowSizeChanged - called when the event indicates that the size of       |
|                       the window with window handle handle has changed.      |
------------------------------------------------------------------------------*/
virtual Boolean
  windowSizeChanged ( IWindowHandle     handle,
                      const IRectangle& newWindowRect,
                      const IRectangle& oldWindowRect  );

private:
/*--------------------------------- Private ----------------------------------*/
IRecoordHandlerData
 *fRecoordHandlerData;
}; // IRecoordHandler

#pragma pack()

#endif /* _IRECOHDR_ */
