/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IREL_H
#define _IREL_H

#include <iarel.h>
#include <iicrel.h>
#include <iivrel.h>
#include <iirelhsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGRelation;

template <class Element, class Key, class ElementOps>
class IGRelationCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGRelation
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationCursor
                            (IGRelation
                              <
                               Element, Key, ElementOps> const&);

  IGRelationCursor <Element, Key, ElementOps>&
           operator=        (IGRelationCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGRelation :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelation <Element, Key, ElementOps> Self;

  typedef  IRelationAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationTypedef (Element, Key, ElementOps);

public:

  typedef  IGRelationCursor
            <Element, Key, ElementOps> Cursor;


           IGRelation
                            (INumber = 100);

           IGRelation
                            (IGRelation
                              <
                               Element, Key, ElementOps> const&);

  IGRelation <Element, Key, ElementOps>&
           operator=        (IGRelation
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGRelation
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelation
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IRelation :
  public IGRelation
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IGRelation
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef  IRelation <Element, Key> Self;

#define IRelationTypedef(Element, Key)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IRelation
                            (INumber = 100);


protected:

           IRelation
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGRelation :
  public IGRelation
          <Element, Key, ElementOps > {

  typedef  IVGRelation
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationTypedef (Element, Key, ElementOps);

public:

           IVGRelation
                            (INumber = 100);


protected:

           IVGRelation
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVRelation :
  public IVGRelation
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IVGRelation
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef  IVRelation <Element, Key> Self;

#define IVRelationTypedef(Element, Key)\
  typedef  IVRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVRelation
                            (INumber = 100);


protected:

           IVRelation
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <irel.inl>

#pragma info (restore)
#pragma pack ()

#endif
