/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGRelationCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationCursor <Element, Key, ElementOps>::
IGRelationCursor
  (IGRelation
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGRelationCursor <Element, Key, ElementOps>&
IGRelationCursor <Element, Key, ElementOps>::
operator=
  (IGRelationCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationCursor <Element, Key, ElementOps>::
IGRelationCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGRelation
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelation <Element, Key, ElementOps>::
IGRelation (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGRelation <Element, Key, ElementOps>::
IGRelation
  (IGRelation
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGRelation <Element, Key, ElementOps>&
IGRelation <Element, Key, ElementOps>::
operator= (IGRelation
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelation <Element, Key, ElementOps>::
IGRelation (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGRelation
 <Element, Key, ElementOps>::Implementation&
IGRelation <Element, Key, ElementOps>::
ImplOf (IGRelation
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IRelation
// ---

// public members

template <class Element, class Key>
inline
IRelation <Element, Key>::
IRelation (INumber numberOfElements)
: IGRelation
   <Element, Key, IEKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IRelation <Element, Key>::
IRelation (PureImplementation& impl)
: IGRelation
   <Element, Key, IEKEHOps <Element, Key> > (impl)
{
}

// ---
// IVGRelation
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGRelation <Element, Key, ElementOps>::
IVGRelation (INumber numberOfElements)
: IGRelation
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGRelation <Element, Key, ElementOps>::
IVGRelation (PureImplementation& impl)
: IGRelation
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVRelation
// ---

// public members

template <class Element, class Key>
inline
IVRelation <Element, Key>::
IVRelation (INumber numberOfElements)
: IVGRelation
   <Element, Key, IEKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVRelation <Element, Key>::
IVRelation (PureImplementation& impl)
: IVGRelation
   <Element, Key, IEKEHOps <Element, Key> > (impl)
{
}
