/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IRELDIL_H
#define _IRELDIL_H

#include <iarel.h>
#include <iicrel.h>
#include <iivrel.h>
#include <iireldil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGRelationAsDilTable;

template <class Element, class Key, class ElementOps>
class IGRelationAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGRelationAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsDilTableCursor
                            (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGRelationAsDilTable :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsDilTable <Element, Key, ElementOps> Self;

  typedef  IRelationAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGRelationAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGRelationAsDilTable
                            (INumber = 100);

           IGRelationAsDilTable
                            (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsDilTable <Element, Key, ElementOps>&
           operator=        (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGRelationAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IRelationAsDilTable :
  public IGRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IRelationAsDilTable <Element, Key> Self;

#define IRelationAsDilTableTypedef(Element, Key)\
  typedef  IRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IRelationAsDilTable
                            (INumber = 100);


protected:

           IRelationAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGRelationAsDilTable :
  public IGRelationAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGRelationAsDilTable
                            (INumber = 100);


protected:

           IVGRelationAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVRelationAsDilTable :
  public IVGRelationAsDilTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGRelationAsDilTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVRelationAsDilTable <Element, Key> Self;

#define IVRelationAsDilTableTypedef(Element, Key)\
  typedef  IVRelationAsDilTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVRelationAsDilTable
                            (INumber = 100);


protected:

           IVRelationAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ireldil.inl>

#pragma info (restore)
#pragma pack ()

#endif
