/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGRelationAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsDilTableCursor <Element, Key, ElementOps>::
IGRelationAsDilTableCursor
  (IGRelationAsDilTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsDilTableCursor <Element, Key, ElementOps>&
IGRelationAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGRelationAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsDilTableCursor <Element, Key, ElementOps>::
IGRelationAsDilTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGRelationAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsDilTable <Element, Key, ElementOps>::
IGRelationAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGRelationAsDilTable <Element, Key, ElementOps>::
IGRelationAsDilTable
  (IGRelationAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsDilTable <Element, Key, ElementOps>&
IGRelationAsDilTable <Element, Key, ElementOps>::
operator= (IGRelationAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsDilTable <Element, Key, ElementOps>::
IGRelationAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGRelationAsDilTable <Element, Key, ElementOps>::
ImplOf (IGRelationAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IRelationAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IRelationAsDilTable <Element, Key>::
IRelationAsDilTable (INumber numberOfElements)
: IGRelationAsDilTable
   <Element, Key, IEKCHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IRelationAsDilTable <Element, Key>::
IRelationAsDilTable (PureImplementation& impl)
: IGRelationAsDilTable
   <Element, Key, IEKCHOps <Element, Key> > (impl)
{
}

// ---
// IVGRelationAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsDilTable <Element, Key, ElementOps>::
IVGRelationAsDilTable (INumber numberOfElements)
: IGRelationAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsDilTable <Element, Key, ElementOps>::
IVGRelationAsDilTable (PureImplementation& impl)
: IGRelationAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVRelationAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVRelationAsDilTable <Element, Key>::
IVRelationAsDilTable (INumber numberOfElements)
: IVGRelationAsDilTable
   <Element, Key, IEKCHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVRelationAsDilTable <Element, Key>::
IVRelationAsDilTable (PureImplementation& impl)
: IVGRelationAsDilTable
   <Element, Key, IEKCHOps <Element, Key> > (impl)
{
}
