/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IRELHSH_H
#define _IRELHSH_H

#include <iarel.h>
#include <iicrel.h>
#include <iivrel.h>
#include <iirelhsh.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGRelationAsHshTable;

template <class Element, class Key, class ElementOps>
class IGRelationAsHshTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGRelationAsHshTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsHshTableCursor
                            (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsHshTableCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsHshTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsHshTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGRelationAsHshTable :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsHshTable <Element, Key, ElementOps> Self;

  typedef  IRelationAsHshTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsHshTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGRelationAsHshTableCursor
            <Element, Key, ElementOps> Cursor;


           IGRelationAsHshTable
                            (INumber = 100);

           IGRelationAsHshTable
                            (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsHshTable <Element, Key, ElementOps>&
           operator=        (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGRelationAsHshTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsHshTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsHshTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IRelationAsHshTable :
  public IGRelationAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IGRelationAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef  IRelationAsHshTable <Element, Key> Self;

#define IRelationAsHshTableTypedef(Element, Key)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IRelationAsHshTable
                            (INumber = 100);


protected:

           IRelationAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGRelationAsHshTable :
  public IGRelationAsHshTable
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsHshTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsHshTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsHshTableTypedef (Element, Key, ElementOps);

public:

           IVGRelationAsHshTable
                            (INumber = 100);


protected:

           IVGRelationAsHshTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVRelationAsHshTable :
  public IVGRelationAsHshTable
          <Element, Key, IEKEHOps <Element, Key> > {

  typedef  IVGRelationAsHshTable
            <Element, Key,
             IEKEHOps <Element, Key> > Inherited;

protected:

  typedef  IVRelationAsHshTable <Element, Key> Self;

#define IVRelationAsHshTableTypedef(Element, Key)\
  typedef  IVRelationAsHshTableOps\
            <Element, Key,\
             IWEKEHOps <Element, Key, IEKEHOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVRelationAsHshTable
                            (INumber = 100);


protected:

           IVRelationAsHshTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <irelhsh.inl>

#pragma info (restore)
#pragma pack ()

#endif
