/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGRelationAsHshTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsHshTableCursor <Element, Key, ElementOps>::
IGRelationAsHshTableCursor
  (IGRelationAsHshTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsHshTableCursor <Element, Key, ElementOps>&
IGRelationAsHshTableCursor <Element, Key, ElementOps>::
operator=
  (IGRelationAsHshTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsHshTableCursor <Element, Key, ElementOps>::
IGRelationAsHshTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGRelationAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsHshTable <Element, Key, ElementOps>::
IGRelationAsHshTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGRelationAsHshTable <Element, Key, ElementOps>::
IGRelationAsHshTable
  (IGRelationAsHshTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsHshTable <Element, Key, ElementOps>&
IGRelationAsHshTable <Element, Key, ElementOps>::
operator= (IGRelationAsHshTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsHshTable <Element, Key, ElementOps>::
IGRelationAsHshTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsHshTable
 <Element, Key, ElementOps>::Implementation&
IGRelationAsHshTable <Element, Key, ElementOps>::
ImplOf (IGRelationAsHshTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IRelationAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IRelationAsHshTable <Element, Key>::
IRelationAsHshTable (INumber numberOfElements)
: IGRelationAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IRelationAsHshTable <Element, Key>::
IRelationAsHshTable (PureImplementation& impl)
: IGRelationAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (impl)
{
}

// ---
// IVGRelationAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsHshTable <Element, Key, ElementOps>::
IVGRelationAsHshTable (INumber numberOfElements)
: IGRelationAsHshTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsHshTable <Element, Key, ElementOps>::
IVGRelationAsHshTable (PureImplementation& impl)
: IGRelationAsHshTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVRelationAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IVRelationAsHshTable <Element, Key>::
IVRelationAsHshTable (INumber numberOfElements)
: IVGRelationAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVRelationAsHshTable <Element, Key>::
IVRelationAsHshTable (PureImplementation& impl)
: IVGRelationAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (impl)
{
}
