/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGRelationAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsListCursor <Element, Key, ElementOps>::
IGRelationAsListCursor
  (IGRelationAsList
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsListCursor <Element, Key, ElementOps>&
IGRelationAsListCursor <Element, Key, ElementOps>::
operator=
  (IGRelationAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsListCursor <Element, Key, ElementOps>::
IGRelationAsListCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGRelationAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsList <Element, Key, ElementOps>::
IGRelationAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGRelationAsList <Element, Key, ElementOps>::
IGRelationAsList
  (IGRelationAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsList <Element, Key, ElementOps>&
IGRelationAsList <Element, Key, ElementOps>::
operator= (IGRelationAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsList <Element, Key, ElementOps>::
IGRelationAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsList
 <Element, Key, ElementOps>::Implementation&
IGRelationAsList <Element, Key, ElementOps>::
ImplOf (IGRelationAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IRelationAsList
// ---

// public members

template <class Element, class Key>
inline
IRelationAsList <Element, Key>::
IRelationAsList (INumber numberOfElements)
: IGRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IRelationAsList <Element, Key>::
IRelationAsList (PureImplementation& impl)
: IGRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGRelationAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsList <Element, Key, ElementOps>::
IVGRelationAsList (INumber numberOfElements)
: IGRelationAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsList <Element, Key, ElementOps>::
IVGRelationAsList (PureImplementation& impl)
: IGRelationAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVRelationAsList
// ---

// public members

template <class Element, class Key>
inline
IVRelationAsList <Element, Key>::
IVRelationAsList (INumber numberOfElements)
: IVGRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVRelationAsList <Element, Key>::
IVRelationAsList (PureImplementation& impl)
: IVGRelationAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
