/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IRELTAB_H
#define _IRELTAB_H

#include <iarel.h>
#include <iicrel.h>
#include <iivrel.h>
#include <iireltab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGRelationAsTable;

template <class Element, class Key, class ElementOps>
class IGRelationAsTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGRelationAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGRelationAsTableCursor
                            (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGRelationAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGRelationAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGRelationAsTable :
  public IARelation <Element, Key> {
protected:

  typedef  IGRelationAsTable <Element, Key, ElementOps> Self;

  typedef  IRelationAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICRelationImpl
            <PureImplementation> Implementation;
#endif

#define IGRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGRelationAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGRelationAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGRelationAsTable
                            (INumber = 100);

           IGRelationAsTable
                            (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGRelationAsTable <Element, Key, ElementOps>&
           operator=        (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGRelationAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGRelationAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGRelationAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IRelationAsTable :
  public IGRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IRelationAsTable <Element, Key> Self;

#define IRelationAsTableTypedef(Element, Key)\
  typedef  IRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IRelationAsTable
                            (INumber = 100);


protected:

           IRelationAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGRelationAsTable :
  public IGRelationAsTable
          <Element, Key, ElementOps > {

  typedef  IVGRelationAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVRelationImpl
            <PureImplementation> Implementation;
#else
  typedef  ICRelationImpl
            <IVRelationImpl
              <PureImplementation> > Implementation;
#endif

#define IVGRelationAsTableTypedef(Element, Key, ElementOps)\
  typedef  IRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGRelationAsTableTypedef (Element, Key, ElementOps);

public:

           IVGRelationAsTable
                            (INumber = 100);


protected:

           IVGRelationAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVRelationAsTable :
  public IVGRelationAsTable
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGRelationAsTable
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVRelationAsTable <Element, Key> Self;

#define IVRelationAsTableTypedef(Element, Key)\
  typedef  IVRelationAsTableOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVRelationAsTable
                            (INumber = 100);


protected:

           IVRelationAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ireltab.inl>

#pragma info (restore)
#pragma pack ()

#endif
