/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGRelationAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsTableCursor <Element, Key, ElementOps>::
IGRelationAsTableCursor
  (IGRelationAsTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsTableCursor <Element, Key, ElementOps>&
IGRelationAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGRelationAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsTableCursor <Element, Key, ElementOps>::
IGRelationAsTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGRelationAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsTable <Element, Key, ElementOps>::
IGRelationAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGRelationAsTable <Element, Key, ElementOps>::
IGRelationAsTable
  (IGRelationAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsTable <Element, Key, ElementOps>&
IGRelationAsTable <Element, Key, ElementOps>::
operator= (IGRelationAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGRelationAsTable <Element, Key, ElementOps>::
IGRelationAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGRelationAsTable
 <Element, Key, ElementOps>::Implementation&
IGRelationAsTable <Element, Key, ElementOps>::
ImplOf (IGRelationAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IRelationAsTable
// ---

// public members

template <class Element, class Key>
inline
IRelationAsTable <Element, Key>::
IRelationAsTable (INumber numberOfElements)
: IGRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IRelationAsTable <Element, Key>::
IRelationAsTable (PureImplementation& impl)
: IGRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGRelationAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsTable <Element, Key, ElementOps>::
IVGRelationAsTable (INumber numberOfElements)
: IGRelationAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGRelationAsTable <Element, Key, ElementOps>::
IVGRelationAsTable (PureImplementation& impl)
: IGRelationAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVRelationAsTable
// ---

// public members

template <class Element, class Key>
inline
IVRelationAsTable <Element, Key>::
IVRelationAsTable (INumber numberOfElements)
: IVGRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVRelationAsTable <Element, Key>::
IVRelationAsTable (PureImplementation& impl)
: IVGRelationAsTable
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
