#ifndef _IRESLIB_
#define _IRESLIB_
/*******************************************************************************
* FILE NAME: ireslib.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IResourceLibrary                                                         *
*     IDynamicLinkLibrary                                                      *
*     IResourceId                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>
#include <ihandle.hpp>

class IString;
class IDLLModule;
class ISize;
class IWindow;
class IMenu;
class IResLibPrivateData;

#pragma pack(4)

class IResourceLibrary  : public IVBase {
typedef IVBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IResourceLibrary   ( );
  IResourceLibrary   ( const IResourceLibrary& resLibrary );
virtual
 ~IResourceLibrary   ( );

IResourceLibrary
 &operator=           ( const IResourceLibrary& resLibrary );

/*---------------------------- Resource Information --------------------------*/
virtual IString
  fileName           ( ) const;

virtual Boolean
  isOpen             ( ) const;

virtual IModuleHandle
  handle             ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
virtual IString
  asString           ( ) const,
  asDebugInfo        ( ) const;


/*------------------------------ Resource Loading ----------------------------*/
virtual IString
  loadString      ( unsigned long stringId  ) const,
  loadMessage     ( unsigned long messageId ) const;


virtual IMenuHandle
  loadMenu        ( unsigned long menuId,
                    IWindow*      menuOwner ) const;

virtual IWindowHandle
  loadDialog      ( unsigned long dialogId,
                    IWindow*      dialogParent,
                    IWindow*      dialogOwner,
                    IWinProc*     dialogProcedure,
                    void*         dialogCreateParameters ) const;


virtual IAccelTblHandle
  loadAccelTable  ( unsigned long accelTableId ) const;

virtual IResourceLibrary
 &loadHelpTable   ( IWindow*      helpInstance,
                    unsigned long helpTableId ) const;

virtual IPointerHandle
  loadIcon        ( unsigned long iconId,
                    Boolean       cached = true ) const,
  loadPointer     ( unsigned long iconId,
                    Boolean       cached = true ) const;

virtual IBitmapHandle
  loadBitmap      ( unsigned long bitmapId,
                    Boolean       cached = true ) const,
  loadBitmap      ( unsigned long bitmapId,
                    const ISize&  bitmapSize,
                    Boolean       cached = true ) const;


virtual IString
  tryToLoadString      ( unsigned long stringId  ) const,
  tryToLoadMessage     ( unsigned long messageId ) const;

virtual IPointerHandle
  tryToLoadIcon        ( unsigned long iconId,
                         Boolean       cached = true ) const;

virtual IBitmapHandle
  tryToLoadBitmap     ( unsigned long bitmapId,
                        Boolean       cached = true ) const,
  tryToLoadBitmap     ( unsigned long bitmapId,
                        const ISize&  bitmapSize,
                        Boolean       cached = true ) const;

private:
/*-------------------------------- Private -----------------------------------*/
char
 *loadText       ( Boolean       isString,
                   unsigned long stringID,
                   char*         buffer = 0,
                   unsigned long length = 0,
                   Boolean       throwException = true ) const;


static unsigned long
  addRef          ( const IPointerHandle& pointerHandle ),
  addRef          ( const IBitmapHandle&  bitmapHandle ),
  removeRef       ( const IPointerHandle& pointerHandle ),
  removeRef       ( const IBitmapHandle&  bitmapHandle );

static unsigned long
  systemPointer ( unsigned long systemPointerId,
                  Boolean       fCopy = false,
                  Boolean       fIconApi = false );
static unsigned long
  systemBitmap  ( unsigned long systemBitmapId);

IResLibPrivateData
 *ppd;

IModuleHandle
  hInstance;

friend class IPointerHandle;
friend class IBitmapHandle;
friend class ISystemPointerHandle;
friend class ISystemBitmapHandle;
friend class ICnrObjPrivateData;


};  // IResourceLibrary


class IDynamicLinkLibrary : public IResourceLibrary
{
typedef IResourceLibrary
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IDynamicLinkLibrary   ( const char*                resourceFileName );
  IDynamicLinkLibrary   ( const IModuleHandle&       moduleHandle );
  IDynamicLinkLibrary   ( const IDynamicLinkLibrary& dllLibrary );

virtual
  ~IDynamicLinkLibrary  ( );

IDynamicLinkLibrary
 &operator=             ( const IDynamicLinkLibrary& dllLibrary );

/*-------------------------- Opening and Closing -----------------------------*/
virtual IDynamicLinkLibrary
 &open                ( ),
 &close               ( );

/*----------------------- Procedure Address Loading --------------------------*/
void
 *procAddress       ( const char*   procedureName ) const,
 *procAddress       ( unsigned long procedureOrdinal ) const;

Boolean
  isEntryPoint32Bit ( const char*   procedureName ) const,
  isEntryPoint32Bit ( unsigned long procedureOrdinal ) const;

/*--------------------- Dynamic Link Library Information ---------------------*/
virtual Boolean
  isOpen           ( ) const;

virtual IString
  fileName         ( ) const;

virtual IModuleHandle
  handle           ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
virtual IString
  asString         ( ) const,
  asDebugInfo      ( ) const;


private:
/*-------------------------------- Private -----------------------------------*/
static unsigned long
  addRef          ( const IModuleHandle& moduleHandle ),
  removeRef       ( const IModuleHandle& moduleHandle );

IDLLModule
 *pmodClResource;
};


class IResourceId  : public IBase
{
typedef IBase
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IResourceId      ( unsigned long              resourceId,
                     const IResourceLibrary&    resourceLibrary );
  IResourceId      ( unsigned long              resourceId,
                     const IDynamicLinkLibrary& dllLibrary );

  IResourceId      ( unsigned long              resourceId );

/*--------------------------------- Resources --------------------------------*/
unsigned long
  id                    ( ) const;

operator unsigned long  ( ) const;

const IResourceLibrary
 &resourceLibrary       ( ) const;

/*-------------------------------- Diagnostics -------------------------------*/
IString
  asString         ( ) const,
  asDebugInfo      ( ) const;


private:
/*------------------------------ Hidden Members ------------------------------*/
IResourceId
  &operator=    ( const IResourceId& resourceId );

/*--------------------------------- Private ----------------------------------*/
unsigned long
  ulClId;

const IResourceLibrary
 &reslibCl;

}; // IResourceId

#pragma pack()

  #include <ireslib.inl>

#endif /* _IRESLIB_ */
