#ifndef _IRESLIB_INL_
#define _IRESLIB_INL_ 0
/*******************************************************************************
* FILE NAME: ireslib.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   classes declared in ireslib.hpp.                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IRESLIB_
  #undef  _IRESLIB_INL_
  #define _IRESLIB_INL_ 1
  #include <ireslib.hpp>
#endif

#include <iapp.hpp>

#if _IRESLIB_INL_
  #define inline
#endif

inline IResourceId :: IResourceId(unsigned long resourceId, const IResourceLibrary& resourceLibrary)
                     : reslibCl(resourceLibrary), ulClId(resourceId)

{ }

inline IResourceId :: IResourceId(unsigned long resourceId, const IDynamicLinkLibrary& dllLibrary)
                     : reslibCl(dllLibrary), ulClId(resourceId)

{ }

inline IResourceId :: IResourceId(unsigned long resourceId)
                       : reslibCl ( IApplication::current().userResourceLibrary() ),
                         ulClId   ( resourceId )

{ }

inline const IResourceLibrary& IResourceId::resourceLibrary() const
{ return reslibCl; }

inline IResourceId::operator unsigned long( )   const
{ return this->ulClId; }

inline unsigned long IResourceId::id( )   const
{ return this->ulClId; }

#endif // _IRESLIB_INL_
