/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedBagCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagCursor <Element, ElementOps>::
IGSortedBagCursor
  (IGSortedBag
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedBagCursor <Element, ElementOps>&
IGSortedBagCursor <Element, ElementOps>::
operator=
  (IGSortedBagCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagCursor <Element, ElementOps>::
IGSortedBagCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedBag
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBag <Element, ElementOps>::
IGSortedBag (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedBag <Element, ElementOps>::
IGSortedBag
  (IGSortedBag
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedBag <Element, ElementOps>&
IGSortedBag <Element, ElementOps>::
operator= (IGSortedBag
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBag <Element, ElementOps>::
IGSortedBag (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedBag
 <Element, ElementOps>::Implementation&
IGSortedBag <Element, ElementOps>::
ImplOf (IGSortedBag
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedBag
// ---

// public members

template <class Element>
inline
ISortedBag <Element>::
ISortedBag (INumber numberOfElements)
: IGSortedBag
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedBag <Element>::
ISortedBag (PureImplementation& impl)
: IGSortedBag
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedBag
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedBag <Element, ElementOps>::
IVGSortedBag (INumber numberOfElements)
: IGSortedBag
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedBag <Element, ElementOps>::
IVGSortedBag (PureImplementation& impl)
: IGSortedBag
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedBag
// ---

// public members

template <class Element>
inline
IVSortedBag <Element>::
IVSortedBag (INumber numberOfElements)
: IVGSortedBag
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedBag <Element>::
IVSortedBag (PureImplementation& impl)
: IVGSortedBag
   <Element, ICOps <Element> > (impl)
{
}
