/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISBAVL_H
#define _ISBAVL_H

#include <iasb.h>
#include <iicsb.h>
#include <iivsb.h>
#include <iisblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedBagAsAvlTree;

template <class Element, class ElementOps>
class IGSortedBagAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedBagAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsAvlTreeCursor
                            (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedBagAsAvlTree :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsAvlTree <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef  IGSortedBagAsAvlTreeCursor
            <Element, ElementOps> Cursor;


           IGSortedBagAsAvlTree
                            (INumber = 100);

           IGSortedBagAsAvlTree
                            (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsAvlTree <Element, ElementOps>&
           operator=        (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedBagAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsAvlTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedBagAsAvlTree :
  public IGSortedBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedBagAsAvlTree <Element> Self;

#define ISortedBagAsAvlTreeTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedBagAsAvlTree
                            (INumber = 100);


protected:

           ISortedBagAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedBagAsAvlTree :
  public IGSortedBagAsAvlTree
          <Element, ElementOps > {

  typedef  IVGSortedBagAsAvlTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsAvlTreeTypedef (Element, ElementOps);

public:

           IVGSortedBagAsAvlTree
                            (INumber = 100);


protected:

           IVGSortedBagAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedBagAsAvlTree :
  public IVGSortedBagAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedBagAsAvlTree <Element> Self;

#define IVSortedBagAsAvlTreeTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedBagAsAvlTree
                            (INumber = 100);


protected:

           IVSortedBagAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isbavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
