/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISBBST_H
#define _ISBBST_H

#include <iasb.h>
#include <iicsb.h>
#include <iivsb.h>
#include <iisblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedBagAsBstTree;

template <class Element, class ElementOps>
class IGSortedBagAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedBagAsBstTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsBstTreeCursor
                            (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsBstTreeCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsBstTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedBagAsBstTree :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsBstTree <Element, ElementOps> Self;

  typedef  ISortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsBstTreeTypedef (Element, ElementOps);

public:

  typedef  IGSortedBagAsBstTreeCursor
            <Element, ElementOps> Cursor;


           IGSortedBagAsBstTree
                            (INumber = 100);

           IGSortedBagAsBstTree
                            (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsBstTree <Element, ElementOps>&
           operator=        (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedBagAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsBstTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsBstTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedBagAsBstTree :
  public IGSortedBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedBagAsBstTree <Element> Self;

#define ISortedBagAsBstTreeTypedef(Element)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedBagAsBstTree
                            (INumber = 100);


protected:

           ISortedBagAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedBagAsBstTree :
  public IGSortedBagAsBstTree
          <Element, ElementOps > {

  typedef  IVGSortedBagAsBstTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsBstTreeTypedef(Element, ElementOps)\
  typedef  ISortedBagAsListOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsBstTreeTypedef (Element, ElementOps);

public:

           IVGSortedBagAsBstTree
                            (INumber = 100);


protected:

           IVGSortedBagAsBstTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedBagAsBstTree :
  public IVGSortedBagAsBstTree
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsBstTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedBagAsBstTree <Element> Self;

#define IVSortedBagAsBstTreeTypedef(Element)\
  typedef  IVSortedBagAsListOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedBagAsBstTree
                            (INumber = 100);


protected:

           IVSortedBagAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isbbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
