/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedBagAsBstTreeCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsBstTreeCursor <Element, ElementOps>::
IGSortedBagAsBstTreeCursor
  (IGSortedBagAsBstTree
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedBagAsBstTreeCursor <Element, ElementOps>&
IGSortedBagAsBstTreeCursor <Element, ElementOps>::
operator=
  (IGSortedBagAsBstTreeCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsBstTreeCursor <Element, ElementOps>::
IGSortedBagAsBstTreeCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedBagAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsBstTree <Element, ElementOps>::
IGSortedBagAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedBagAsBstTree <Element, ElementOps>::
IGSortedBagAsBstTree
  (IGSortedBagAsBstTree
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedBagAsBstTree <Element, ElementOps>&
IGSortedBagAsBstTree <Element, ElementOps>::
operator= (IGSortedBagAsBstTree
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsBstTree <Element, ElementOps>::
IGSortedBagAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedBagAsBstTree
 <Element, ElementOps>::Implementation&
IGSortedBagAsBstTree <Element, ElementOps>::
ImplOf (IGSortedBagAsBstTree
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedBagAsBstTree
// ---

// public members

template <class Element>
inline
ISortedBagAsBstTree <Element>::
ISortedBagAsBstTree (INumber numberOfElements)
: IGSortedBagAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedBagAsBstTree <Element>::
ISortedBagAsBstTree (PureImplementation& impl)
: IGSortedBagAsBstTree
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedBagAsBstTree
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedBagAsBstTree <Element, ElementOps>::
IVGSortedBagAsBstTree (INumber numberOfElements)
: IGSortedBagAsBstTree
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedBagAsBstTree <Element, ElementOps>::
IVGSortedBagAsBstTree (PureImplementation& impl)
: IGSortedBagAsBstTree
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedBagAsBstTree
// ---

// public members

template <class Element>
inline
IVSortedBagAsBstTree <Element>::
IVSortedBagAsBstTree (INumber numberOfElements)
: IVGSortedBagAsBstTree
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedBagAsBstTree <Element>::
IVSortedBagAsBstTree (PureImplementation& impl)
: IVGSortedBagAsBstTree
   <Element, ICOps <Element> > (impl)
{
}
