/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISBDIL_H
#define _ISBDIL_H

#include <iasb.h>
#include <iicsb.h>
#include <iivsb.h>
#include <iisbdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedBagAsDilTable;

template <class Element, class ElementOps>
class IGSortedBagAsDilTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedBagAsDilTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsDilTableCursor
                            (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsDilTableCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsDilTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedBagAsDilTable :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsDilTable <Element, ElementOps> Self;

  typedef  ISortedBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsDilTableTypedef (Element, ElementOps);

public:

  typedef  IGSortedBagAsDilTableCursor
            <Element, ElementOps> Cursor;


           IGSortedBagAsDilTable
                            (INumber = 100);

           IGSortedBagAsDilTable
                            (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsDilTable <Element, ElementOps>&
           operator=        (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedBagAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsDilTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsDilTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedBagAsDilTable :
  public IGSortedBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedBagAsDilTable <Element> Self;

#define ISortedBagAsDilTableTypedef(Element)\
  typedef  ISortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedBagAsDilTable
                            (INumber = 100);


protected:

           ISortedBagAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedBagAsDilTable :
  public IGSortedBagAsDilTable
          <Element, ElementOps > {

  typedef  IVGSortedBagAsDilTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsDilTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsDilTableTypedef (Element, ElementOps);

public:

           IVGSortedBagAsDilTable
                            (INumber = 100);


protected:

           IVGSortedBagAsDilTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedBagAsDilTable :
  public IVGSortedBagAsDilTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsDilTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedBagAsDilTable <Element> Self;

#define IVSortedBagAsDilTableTypedef(Element)\
  typedef  IVSortedBagAsDilTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedBagAsDilTable
                            (INumber = 100);


protected:

           IVSortedBagAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isbdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
