/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSortedBagAsDilTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsDilTableCursor <Element, ElementOps>::
IGSortedBagAsDilTableCursor
  (IGSortedBagAsDilTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSortedBagAsDilTableCursor <Element, ElementOps>&
IGSortedBagAsDilTableCursor <Element, ElementOps>::
operator=
  (IGSortedBagAsDilTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsDilTableCursor <Element, ElementOps>::
IGSortedBagAsDilTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSortedBagAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSortedBagAsDilTable <Element, ElementOps>::
IGSortedBagAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSortedBagAsDilTable <Element, ElementOps>::
IGSortedBagAsDilTable
  (IGSortedBagAsDilTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSortedBagAsDilTable <Element, ElementOps>&
IGSortedBagAsDilTable <Element, ElementOps>::
operator= (IGSortedBagAsDilTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSortedBagAsDilTable <Element, ElementOps>::
IGSortedBagAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSortedBagAsDilTable
 <Element, ElementOps>::Implementation&
IGSortedBagAsDilTable <Element, ElementOps>::
ImplOf (IGSortedBagAsDilTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISortedBagAsDilTable
// ---

// public members

template <class Element>
inline
ISortedBagAsDilTable <Element>::
ISortedBagAsDilTable (INumber numberOfElements)
: IGSortedBagAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISortedBagAsDilTable <Element>::
ISortedBagAsDilTable (PureImplementation& impl)
: IGSortedBagAsDilTable
   <Element, ICOps <Element> > (impl)
{
}

// ---
// IVGSortedBagAsDilTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSortedBagAsDilTable <Element, ElementOps>::
IVGSortedBagAsDilTable (INumber numberOfElements)
: IGSortedBagAsDilTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSortedBagAsDilTable <Element, ElementOps>::
IVGSortedBagAsDilTable (PureImplementation& impl)
: IGSortedBagAsDilTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSortedBagAsDilTable
// ---

// public members

template <class Element>
inline
IVSortedBagAsDilTable <Element>::
IVSortedBagAsDilTable (INumber numberOfElements)
: IVGSortedBagAsDilTable
   <Element, ICOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSortedBagAsDilTable <Element>::
IVSortedBagAsDilTable (PureImplementation& impl)
: IVGSortedBagAsDilTable
   <Element, ICOps <Element> > (impl)
{
}
