/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISBTAB_H
#define _ISBTAB_H

#include <iasb.h>
#include <iicsb.h>
#include <iivsb.h>
#include <iisbtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSortedBagAsTable;

template <class Element, class ElementOps>
class IGSortedBagAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSortedBagAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSortedBagAsTableCursor
                            (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsTableCursor <Element, ElementOps>&
           operator=        (IGSortedBagAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSortedBagAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSortedBagAsTable :
  public IASortedBag <Element> {
protected:

  typedef  IGSortedBagAsTable <Element, ElementOps> Self;

  typedef  ISortedBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGSortedBagAsTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSortedBagAsTableTypedef (Element, ElementOps);

public:

  typedef  IGSortedBagAsTableCursor
            <Element, ElementOps> Cursor;


           IGSortedBagAsTable
                            (INumber = 100);

           IGSortedBagAsTable
                            (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);

  IGSortedBagAsTable <Element, ElementOps>&
           operator=        (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSortedBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSortedBagAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSortedBagAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISortedBagAsTable :
  public IGSortedBagAsTable
          <Element, ICOps <Element> > {

  typedef  IGSortedBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISortedBagAsTable <Element> Self;

#define ISortedBagAsTableTypedef(Element)\
  typedef  ISortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISortedBagAsTable
                            (INumber = 100);


protected:

           ISortedBagAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSortedBagAsTable :
  public IGSortedBagAsTable
          <Element, ElementOps > {

  typedef  IVGSortedBagAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSortedBagImpl
            <IVSortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSortedBagAsTableTypedef(Element, ElementOps)\
  typedef  ISortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSortedBagAsTableTypedef (Element, ElementOps);

public:

           IVGSortedBagAsTable
                            (INumber = 100);


protected:

           IVGSortedBagAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSortedBagAsTable :
  public IVGSortedBagAsTable
          <Element, ICOps <Element> > {

  typedef  IVGSortedBagAsTable
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSortedBagAsTable <Element> Self;

#define IVSortedBagAsTableTypedef(Element)\
  typedef  IVSortedBagAsTableOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSortedBagAsTable
                            (INumber = 100);


protected:

           IVSortedBagAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isbtab.inl>

#pragma info (restore)
#pragma pack ()

#endif
