#ifndef _ISCRLEVT_
  #define _ISCRLEVT_
/*******************************************************************************
* FILE NAME: iscrlevt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IScrollEvent                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

class IScrollBar;

#pragma pack(4)

class IScrollEvent : public IEvent {
typedef IEvent
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IScrollEvent ( const IEvent& event );

virtual
 ~IScrollEvent ( );

/*-------------------------------- Accessors ---------------------------------*/
IScrollBar*
  scrollBarWindow      ( ) const;
long
  scrollAmount         ( ) const;
unsigned long
  newScrollBoxPosition ( ) const;


private:
/*--------------------------------- Private ----------------------------------*/
unsigned long
  ulClPrevScrollBoxPos;
};


#pragma pack()

#endif /* _ISCRLEVT_ */
