#ifndef _ISCRLHDR_
  #define _ISCRLHDR_
/*******************************************************************************
* FILE NAME: iscrlhdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IScrollHandler                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ihandler.hpp>
#include <iscrlevt.hpp>

class IScrollHandlerPrivateData;

#pragma pack(4)

class IScrollHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IScrollHandler ( );
virtual
 ~IScrollHandler ( );

protected:
/*---------------------------- Event Dispatching -----------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent& event );

/*----------------------------- Event Processing -----------------------------*/
virtual Boolean
  lineUp            ( IScrollEvent& event ),
  lineDown          ( IScrollEvent& event ),
  pageUp            ( IScrollEvent& event ),
  pageDown          ( IScrollEvent& event ),
  lineLeft          ( IScrollEvent& event ),
  lineRight         ( IScrollEvent& event ),
  pageLeft          ( IScrollEvent& event ),
  pageRight         ( IScrollEvent& event ),
  scrollBoxTrack    ( IScrollEvent& event ),
  scrollBoxTrackEnd ( IScrollEvent& event ),
  scrollEnd         ( IScrollEvent& event );

/*------------------------------ Implementation ------------------------------*/
virtual IScrollHandler
 &moveScrollBox ( IScrollEvent& event );

private:
/*----------------------------- Hidden Functions -----------------------------*/
  IScrollHandler ( const IScrollHandler &scrollHandler );
IScrollHandler
 &operator=      ( const IScrollHandler &scrollHandler );

/*--------------------------------- Private ----------------------------------*/
}; // IScrollHandler

#pragma pack()

#endif /* _ISCRLHDR_ */
