#ifndef _ISCROLL_
  #define _ISCROLL_
/*******************************************************************************
* FILE NAME: iscroll.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*    IScrollBar                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icontrol.hpp>
#include <irect.hpp>

class IRange;
class IWindowHandle;
class IScrollBarData;
class IColor;
class ISize;

#pragma pack(4)

class IScrollBar : public IControl {
typedef IControl
  Inherited;

public:
class Style;
/*------------------------------- Constructors -------------------------------*/
  IScrollBar ( unsigned long     id,
               IWindow*          parent,
               IWindow*          owner,
               const IRectangle& initial = IRectangle(),
               const Style&      style = defaultStyle() );

  IScrollBar ( unsigned long     id,
               IWindow*          parent,
               IWindow*          owner,
               const IRange&     scrollableItems,
               unsigned long     visibleItemCount,
               unsigned long     scrollBoxPosition = 1,
               const IRectangle& initial = IRectangle(),
               const Style&      style = defaultStyle() );

  IScrollBar ( unsigned long     id,
               IWindow*          parent );

  IScrollBar ( const IWindowHandle& handle );

virtual
 ~IScrollBar ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IScrollBar, IWindow, IControl);
static const Style
  IC_IMPORTU horizontal,
  IC_IMPORTU vertical,
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*------------------------------ System Values -------------------------------*/
static unsigned long
  systemScrollBarWidth     ( Boolean verticalScrollBar = true ),
  systemScrollBoxLength    ( Boolean verticalScrollBar = true ),
  systemScrollButtonLength ( Boolean verticalScrollBar = true );

/*--------------------------- Query Operations -------------------------------*/
Boolean
  isHorizontal ( ) const,
  isVertical   ( ) const;

/*------------------------- Manipulation Operations --------------------------*/
virtual IScrollBar
 &setScrollableRange ( const IRange& minMax ),
 &setVisibleCount    ( unsigned long scrollableRangeUnits ),
 &setScrollBar       ( const IRange& scrollableRange,
                       unsigned long visibleCount );
virtual IScrollBar
 &moveScrollBoxTo    ( unsigned long firstItem = 1 );


virtual IRange
  scrollableRange     ( ) const,
  scrollBoxRange      ( ) const;
virtual unsigned long
  visibleCount        ( ) const,
  scrollBoxPosition   ( ) const;


/*--------------------------- Scrolling Increment ----------------------------*/
virtual unsigned long
  minScrollIncrement     ( ) const,
  pageScrollIncrement    ( ) const;
virtual IScrollBar
 &setMinScrollIncrement  ( unsigned long scrollableRangeUnits = 1 ),
 &setPageScrollIncrement ( unsigned long scrollableRangeUnits = 0 );

/*---------------------------------- Colors ----------------------------------*/
#ifndef IC_WIN_FLAGNOP
virtual IColor
  foregroundColor       () const,
  hiliteForegroundColor () const;
#endif

/*-------------------------------- Overrides ---------------------------------*/

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU scrollBoxPositionId;

/*----------------------- Observer Notification ------------------------------*/
virtual IScrollBar
 &enableNotification ( Boolean enable=true );


protected:
/*--------------------------- Protected Overrides ----------------------------*/
virtual ISize
  calcMinimumSize ( ) const;

/*---------------------- Event-Handling Implementation -----------------------*/


private:
/*------------------------------ Hidden Members ------------------------------*/
  IScrollBar            ( const IScrollBar& scrollBar );
IScrollBar
 &operator=             ( const IScrollBar& scrollBar );

/*--------------------------------- Private ----------------------------------*/
friend class IScrollBarData;
friend class IScrollBarHandler;

void
  initialize( unsigned long     windowId,
              IWindow*          parent,
              IWindow*          owner,
              const IRectangle& initial,
              const IRange&     scrollableItems,
              unsigned long     visibleItemCount,
              unsigned long     scrollBoxPosition,
              const Style&      style );

unsigned long
  ulClMinScrollIncrement,
  ulClPageScrollIncrement;

void
  initializeControlData ( const IRange& scrollableItems,
                          unsigned long visibleItemCount,
                          struct tagSCROLLINFO* controlData );

static Style
  currentDefaultStyle;

IScrollBarData
 *fScrollBarData;

}; // IScrollBar

INESTEDBITFLAGCLASSFUNCS(Style, IScrollBar);

#pragma pack()

  #include <iscroll.inl>

#endif /* _ISCROLL_ */
