/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSequenceAsListCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequenceAsListCursor <Element, ElementOps>::
IGSequenceAsListCursor
  (IGSequenceAsList
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSequenceAsListCursor <Element, ElementOps>&
IGSequenceAsListCursor <Element, ElementOps>::
operator=
  (IGSequenceAsListCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequenceAsListCursor <Element, ElementOps>::
IGSequenceAsListCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSequenceAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequenceAsList <Element, ElementOps>::
IGSequenceAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSequenceAsList <Element, ElementOps>::
IGSequenceAsList
  (IGSequenceAsList
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSequenceAsList <Element, ElementOps>&
IGSequenceAsList <Element, ElementOps>::
operator= (IGSequenceAsList
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequenceAsList <Element, ElementOps>::
IGSequenceAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSequenceAsList
 <Element, ElementOps>::Implementation&
IGSequenceAsList <Element, ElementOps>::
ImplOf (IGSequenceAsList
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISequenceAsList
// ---

// public members

template <class Element>
inline
ISequenceAsList <Element>::
ISequenceAsList (INumber numberOfElements)
: IGSequenceAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISequenceAsList <Element>::
ISequenceAsList (PureImplementation& impl)
: IGSequenceAsList
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGSequenceAsList
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSequenceAsList <Element, ElementOps>::
IVGSequenceAsList (INumber numberOfElements)
: IGSequenceAsList
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSequenceAsList <Element, ElementOps>::
IVGSequenceAsList (PureImplementation& impl)
: IGSequenceAsList
    <Element, ElementOps> (impl)
{
}

// ---
// IVSequenceAsList
// ---

// public members

template <class Element>
inline
IVSequenceAsList <Element>::
IVSequenceAsList (INumber numberOfElements)
: IVGSequenceAsList
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSequenceAsList <Element>::
IVSequenceAsList (PureImplementation& impl)
: IVGSequenceAsList
   <Element, IStdOps <Element> > (impl)
{
}
