/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISEQTAB_H
#define _ISEQTAB_H

#include <iaseq.h>
#include <iicseq.h>
#include <iivseq.h>
#include <iiseqtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSequenceAsTable;

template <class Element, class ElementOps>
class IGSequenceAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGSequenceAsTable
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSequenceAsTableCursor
                            (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsTableCursor <Element, ElementOps>&
           operator=        (IGSequenceAsTableCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSequenceAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSequenceAsTable :
  public IASequence <Element> {
protected:

  typedef  IGSequenceAsTable <Element, ElementOps> Self;

  typedef  ISequenceAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSequenceImpl
            <PureImplementation> Implementation;
#endif

#define IGSequenceAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSequenceAsTableTypedef (Element, ElementOps);

public:

  typedef  IGSequenceAsTableCursor
            <Element, ElementOps> Cursor;


           IGSequenceAsTable
                            (INumber = 100);

           IGSequenceAsTable
                            (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);

  IGSequenceAsTable <Element, ElementOps>&
           operator=        (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);


protected:

           IGSequenceAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSequenceAsTable
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSequenceAsTableCursor
            <Element, ElementOps>;



};

template <class Element>
class ISequenceAsTable :
  public IGSequenceAsTable
          <Element, IStdOps <Element> > {

  typedef  IGSequenceAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  ISequenceAsTable <Element> Self;

#define ISequenceAsTableTypedef(Element)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           ISequenceAsTable
                            (INumber = 100);


protected:

           ISequenceAsTable
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSequenceAsTable :
  public IGSequenceAsTable
          <Element, ElementOps > {

  typedef  IVGSequenceAsTable
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSequenceImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSequenceImpl
            <IVSequenceImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSequenceAsTableTypedef(Element, ElementOps)\
  typedef  ISequenceAsTableOps\
            <Element,\
             IWStdOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSequenceAsTableTypedef (Element, ElementOps);

public:

           IVGSequenceAsTable
                            (INumber = 100);


protected:

           IVGSequenceAsTable
                              (PureImplementation&);

private:


};

template <class Element>
class IVSequenceAsTable :
  public IVGSequenceAsTable
          <Element, IStdOps <Element> > {

  typedef  IVGSequenceAsTable
            <Element,
             IStdOps <Element> > Inherited;

protected:

  typedef  IVSequenceAsTable <Element> Self;

#define IVSequenceAsTableTypedef(Element)\
  typedef  IVSequenceAsTableOps\
            <Element,\
             IWStdOps <Element, IStdOps <Element> >,\
             Implementation> Instantiation

public:

           IVSequenceAsTable
                            (INumber = 100);


protected:

           IVSequenceAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iseqtab.inl>

#pragma info (restore)
#pragma pack ()

#endif
