/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGSequenceAsTableCursor
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequenceAsTableCursor <Element, ElementOps>::
IGSequenceAsTableCursor
  (IGSequenceAsTable
    <Element, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class ElementOps>
inline IGSequenceAsTableCursor <Element, ElementOps>&
IGSequenceAsTableCursor <Element, ElementOps>::
operator=
  (IGSequenceAsTableCursor
    <Element, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequenceAsTableCursor <Element, ElementOps>::
IGSequenceAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGSequenceAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IGSequenceAsTable <Element, ElementOps>::
IGSequenceAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class ElementOps>
inline
IGSequenceAsTable <Element, ElementOps>::
IGSequenceAsTable
  (IGSequenceAsTable
    <Element, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class ElementOps>
inline IGSequenceAsTable <Element, ElementOps>&
IGSequenceAsTable <Element, ElementOps>::
operator= (IGSequenceAsTable
            <Element, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class ElementOps>
inline
IGSequenceAsTable <Element, ElementOps>::
IGSequenceAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class ElementOps>
inline IGSequenceAsTable
 <Element, ElementOps>::Implementation&
IGSequenceAsTable <Element, ElementOps>::
ImplOf (IGSequenceAsTable
         <Element, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// ISequenceAsTable
// ---

// public members

template <class Element>
inline
ISequenceAsTable <Element>::
ISequenceAsTable (INumber numberOfElements)
: IGSequenceAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
ISequenceAsTable <Element>::
ISequenceAsTable (PureImplementation& impl)
: IGSequenceAsTable
   <Element, IStdOps <Element> > (impl)
{
}

// ---
// IVGSequenceAsTable
// ---

// public members

template <class Element, class ElementOps>
inline
IVGSequenceAsTable <Element, ElementOps>::
IVGSequenceAsTable (INumber numberOfElements)
: IGSequenceAsTable
    <Element, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class ElementOps>
inline
IVGSequenceAsTable <Element, ElementOps>::
IVGSequenceAsTable (PureImplementation& impl)
: IGSequenceAsTable
    <Element, ElementOps> (impl)
{
}

// ---
// IVSequenceAsTable
// ---

// public members

template <class Element>
inline
IVSequenceAsTable <Element>::
IVSequenceAsTable (INumber numberOfElements)
: IVGSequenceAsTable
   <Element, IStdOps <Element> > (numberOfElements)
{
}

// protected members

template <class Element>
inline
IVSequenceAsTable <Element>::
IVSequenceAsTable (PureImplementation& impl)
: IVGSequenceAsTable
   <Element, IStdOps <Element> > (impl)
{
}
