/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISET_H
#define _ISET_H

#include <iaset.h>
#include <iicset.h>
#include <iivset.h>
#include <iisetavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSet;

template <class Element, class ElementOps>
class IGSetCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGSet
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetCursor
                            (IGSet
                              <
                               Element, ElementOps> const&);

  IGSetCursor <Element, ElementOps>&
           operator=        (IGSetCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSet :
  public IASet <Element> {
protected:

  typedef  IGSet <Element, ElementOps> Self;

  typedef  ISetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetTypedef (Element, ElementOps);

public:

  typedef  IGSetCursor
            <Element, ElementOps> Cursor;


           IGSet
                            (INumber = 100);

           IGSet
                            (IGSet
                              <
                               Element, ElementOps> const&);

  IGSet <Element, ElementOps>&
           operator=        (IGSet
                              <
                               Element, ElementOps> const&);


protected:

           IGSet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSet
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetCursor
            <Element, ElementOps>;



};

template <class Element>
class ISet :
  public IGSet
          <Element, ICOps <Element> > {

  typedef  IGSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISet <Element> Self;

#define ISetTypedef(Element)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISet
                            (INumber = 100);


protected:

           ISet
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSet :
  public IGSet
          <Element, ElementOps > {

  typedef  IVGSet
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetTypedef (Element, ElementOps);

public:

           IVGSet
                            (INumber = 100);


protected:

           IVGSet
                              (PureImplementation&);

private:


};

template <class Element>
class IVSet :
  public IVGSet
          <Element, ICOps <Element> > {

  typedef  IVGSet
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSet <Element> Self;

#define IVSetTypedef(Element)\
  typedef  IVSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSet
                            (INumber = 100);


protected:

           IVSet
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iset.inl>

#pragma info (restore)
#pragma pack ()

#endif
