/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _ISETAVL_H
#define _ISETAVL_H

#include <iaset.h>
#include <iicset.h>
#include <iivset.h>
#include <iisetavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class ElementOps>
class IGSetAsAvlTree;

template <class Element, class ElementOps>
class IGSetAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGSetAsAvlTree
            <Element, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGSetAsAvlTreeCursor
                            (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSetAsAvlTreeCursor <Element, ElementOps>&
           operator=        (IGSetAsAvlTreeCursor
                              <
                               Element, ElementOps> const&);

protected:

           IGSetAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class ElementOps>
class IGSetAsAvlTree :
  public IASet <Element> {
protected:

  typedef  IGSetAsAvlTree <Element, ElementOps> Self;

  typedef  ISetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICSetImpl
            <PureImplementation> Implementation;
#endif

#define IGSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IGSetAsAvlTreeTypedef (Element, ElementOps);

public:

  typedef  IGSetAsAvlTreeCursor
            <Element, ElementOps> Cursor;


           IGSetAsAvlTree
                            (INumber = 100);

           IGSetAsAvlTree
                            (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);

  IGSetAsAvlTree <Element, ElementOps>&
           operator=        (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);


protected:

           IGSetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGSetAsAvlTree
                              <
                               Element, ElementOps> const&);

private:

  friend
  class    IGSetAsAvlTreeCursor
            <Element, ElementOps>;



};

template <class Element>
class ISetAsAvlTree :
  public IGSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IGSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  ISetAsAvlTree <Element> Self;

#define ISetAsAvlTreeTypedef(Element)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           ISetAsAvlTree
                            (INumber = 100);


protected:

           ISetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class ElementOps>
class IVGSetAsAvlTree :
  public IGSetAsAvlTree
          <Element, ElementOps > {

  typedef  IVGSetAsAvlTree
            <Element, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICSetImpl
            <IVSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGSetAsAvlTreeTypedef(Element, ElementOps)\
  typedef  ISetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ElementOps>,\
             Implementation> Instantiation

           IVGSetAsAvlTreeTypedef (Element, ElementOps);

public:

           IVGSetAsAvlTree
                            (INumber = 100);


protected:

           IVGSetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element>
class IVSetAsAvlTree :
  public IVGSetAsAvlTree
          <Element, ICOps <Element> > {

  typedef  IVGSetAsAvlTree
            <Element,
             ICOps <Element> > Inherited;

protected:

  typedef  IVSetAsAvlTree <Element> Self;

#define IVSetAsAvlTreeTypedef(Element)\
  typedef  IVSetAsAvlTreeOps\
            <Element,\
             IWCOps <Element, ICOps <Element> >,\
             Implementation> Instantiation

public:

           IVSetAsAvlTree
                            (INumber = 100);


protected:

           IVSetAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <isetavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
